import torch


def multivariate_uniform(dim, nullparm, X):

    n,d = X.size()[0], X.size()[1]
    assert dim == d, 'dim doesnot match'
    return torch.zeros(n,d)

def multivariate_Normal_score(mu, cov, X):

    assert mu.dim()  == 2
    assert cov.dim() == 2
    assert X.size()[1] == mu.size()[0]

    if X.size()[1] > 1:
        n = X.size()[0]
        d = X.size()[1]
        out = torch.zeros(n,d)
        for i in range(n):
            x_i = X[i].squeeze().unsqueeze(dim=1)
            assert x_i.size() == mu.size()
            out[i] = -1. * (torch.inverse(cov) @ (x_i - mu) ).squeeze()

    if X.size()[1] == 1:
        n = X.size()[0]
        d = X.size()[1]
        out = torch.zeros(n, d)
        for i in range(n):
            x_i = X[i].squeeze()
            out[i] = -1. * (torch.inverse(cov) @ (x_i - mu)).squeeze()

    return out
