from keras.layers import BatchNormalization
from keras.layers.convolutional import Conv2D
from keras.layers.convolutional import AveragePooling2D
from keras.layers.convolutional import MaxPooling2D
from keras.layers.core import Activation
from keras.layers.core import Dropout
from keras.layers.core import Dense
from keras.layers import Flatten, MaxPool2D
from keras.layers import Input
from keras.models import Model
from keras.layers import concatenate
import matplotlib
matplotlib.use("Agg")

from sklearn.preprocessing import LabelBinarizer
from keras.preprocessing.image import ImageDataGenerator
from keras.callbacks import LearningRateScheduler
from tensorflow.keras.optimizers import SGD
from keras.datasets import cifar10
import numpy as np
from tensorflow import keras
import tensorflow as tf
import tensorflow_probability as tfp
import copy
import pickle
from pathlib import Path




from tensorflow.keras.models import Sequential
from tensorflow.keras.layers import Dense, Flatten, Conv2D, MaxPooling2D
from tensorflow.keras.losses import SparseCategoricalCrossentropy
from tensorflow.keras.optimizers import RMSprop
from keras.datasets import mnist, fashion_mnist, cifar10
import numpy as np
import os
import matplotlib.pyplot as plt


from scipy.stats import mode

plt.rcParams['figure.figsize'] = (10, 6)



from keras.datasets import mnist
import random 
from keras.utils import np_utils

from keras.datasets import mnist
import random
from keras.utils import np_utils

Experiments = 3

batch_size = 100
nb_classes = 10

#use a large number of epochs
nb_epoch = 250

# input image dimensions
img_rows, img_cols = 32, 32
# number of convolutional filters to use
nb_filters = 32
# size of pooling area for max pooling
nb_pool = 2
# convolution kernel size
nb_conv = 4

score=0
all_accuracy = 0
acquisition_iterations = 9

#use a large number of dropout iterations
dropout_iterations = 100
Queries = 1000


Experiments_All_Accuracy = np.zeros(shape=(acquisition_iterations+1))


(X_train_All, y_train_All), (X_test, y_test) = cifar10.load_data()

X_train_All = X_train_All.reshape(X_train_All.shape[0],img_rows, img_cols, 3)
X_test = X_test.reshape(X_test.shape[0],img_rows, img_cols,3)
def load_np(fil_name):
  with open(fil_name, "rb") as f:
    return np.load(f)

# random_split = np.asarray(random.sample(range(0,X_train_All.shape[0]), X_train_All.shape[0]))
rand_path = Path(__file__).resolve().parent.parent.parent
random_split = load_np(os.path.join(rand_path ,"rand_init_4.npy"))

X_train_All = X_train_All[random_split, :, :, :]
y_train_All = y_train_All[random_split]
X_valid = X_train_All[5000:10000, :, :, :]
y_valid = y_train_All[5000:10000]
X_Pool = X_train_All[10000:60000, :, :, :]
y_Pool = y_train_All[10000:60000]
X_train_All = X_train_All[0:5000, :, :, :]
y_train_All = y_train_All[0:5000]

#training data to have equal distribution of classes
idx_0 = np.array( np.where(y_train_All==0)  ).T
idx_0 = idx_0[0:100,0]
X_0 = X_train_All[idx_0, :, :, :]
y_0 = y_train_All[idx_0]

idx_1 = np.array( np.where(y_train_All==1)  ).T
idx_1 = idx_1[0:100,0]
X_1 = X_train_All[idx_1, :, :, :]
y_1 = y_train_All[idx_1]

idx_2 = np.array( np.where(y_train_All==2)  ).T
idx_2 = idx_2[0:100,0]
X_2 = X_train_All[idx_2, :, :, :]
y_2 = y_train_All[idx_2]

idx_3 = np.array( np.where(y_train_All==3)  ).T
idx_3 = idx_3[0:100,0]
X_3 = X_train_All[idx_3, :, :, :]
y_3 = y_train_All[idx_3]

idx_4 = np.array( np.where(y_train_All==4)  ).T
idx_4 = idx_4[0:100,0]
X_4 = X_train_All[idx_4, :, :, :]
y_4 = y_train_All[idx_4]

idx_5 = np.array( np.where(y_train_All==5)  ).T
idx_5 = idx_5[0:100,0]
X_5 = X_train_All[idx_5, :, :, :]
y_5 = y_train_All[idx_5]

idx_6 = np.array( np.where(y_train_All==6)  ).T
idx_6 = idx_6[0:100,0]
X_6 = X_train_All[idx_6, :, :, :]
y_6 = y_train_All[idx_6]

idx_7 = np.array( np.where(y_train_All==7)  ).T
idx_7 = idx_7[0:100,0]
X_7 = X_train_All[idx_7, :, :, :]
y_7 = y_train_All[idx_7]

idx_8 = np.array( np.where(y_train_All==8)  ).T
idx_8 = idx_8[0:100,0]
X_8 = X_train_All[idx_8, :, :, :]
y_8 = y_train_All[idx_8]

idx_9 = np.array( np.where(y_train_All==9)  ).T
idx_9 = idx_9[0:100,0]
X_9 = X_train_All[idx_9, :, :, :]
y_9 = y_train_All[idx_9]

X_train = np.concatenate((X_0, X_1, X_2, X_3, X_4, X_5, X_6, X_7, X_8, X_9), axis=0 )
y_train = np.concatenate((y_0, y_1, y_2, y_3, y_4, y_5, y_6, y_7, y_8, y_9), axis=0 )


print('X_train shape:', X_train.shape)
print(X_train.shape[0], 'train samples')



X_train = X_train.astype('float32')
X_test = X_test.astype('float32')
X_valid = X_valid.astype('float32')
X_Pool = X_Pool.astype('float32')
X_train /= 255
X_valid /= 255
X_Pool /= 255
X_test /= 255

Y_test = np_utils.to_categorical(y_test, nb_classes)
Y_valid = np_utils.to_categorical(y_valid, nb_classes)
Y_Pool = np_utils.to_categorical(y_Pool, nb_classes)


#loss values in each experiment
Pool_Valid_Loss = np.zeros(shape=(nb_epoch, 1))
Pool_Train_Loss = np.zeros(shape=(nb_epoch, 1))
Pool_Valid_Acc = np.zeros(shape=(nb_epoch, 1))
Pool_Train_Acc = np.zeros(shape=(nb_epoch, 1))
x_pool_All = np.zeros(shape=(1))

Y_train = np_utils.to_categorical(y_train, nb_classes)


import numpy as np
import tensorflow as tf
from tensorflow import keras
from tensorflow.keras.utils import to_categorical
from tensorflow.keras.datasets import cifar10
from tensorflow.keras.preprocessing.image import ImageDataGenerator

import tensorflow as tf
from tensorflow.keras.optimizers import Adam

# ######

# baseline model with dropout and data augmentation on the cifar10 dataset
import sys
from matplotlib import pyplot
from keras.datasets import cifar10
# from keras.utils import to_categorical
from keras.models import Sequential
from keras.layers import Conv2D
from keras.layers import MaxPooling2D
from keras.layers import Dense
from keras.layers import Flatten
from tensorflow.keras.optimizers import SGD
from keras.preprocessing.image import ImageDataGenerator
from keras.layers import Dropout
from keras.layers import BatchNormalization


def define_model():
  model = Sequential()
  model.add(Conv2D(64, (3, 3), activation='relu', kernel_initializer='he_uniform', padding='same', input_shape=(32, 32, 3)))
  model.add(BatchNormalization())
  model.add(Conv2D(64, (3, 3), activation='relu', kernel_initializer='he_uniform', padding='same'))
  model.add(BatchNormalization())
  model.add(MaxPooling2D((2, 2)))
  model.add(Dropout(0.2))
  model.add(Conv2D(128, (3, 3), activation='relu', kernel_initializer='he_uniform', padding='same'))
  model.add(BatchNormalization())
  model.add(Conv2D(128, (3, 3), activation='relu', kernel_initializer='he_uniform', padding='same'))
  model.add(BatchNormalization())
  model.add(MaxPooling2D((2, 2)))
  model.add(Dropout(0.3))
  model.add(Conv2D(256, (3, 3), activation='relu', kernel_initializer='he_uniform', padding='same'))
  model.add(BatchNormalization())
  model.add(Conv2D(256, (3, 3), activation='relu', kernel_initializer='he_uniform', padding='same'))
  model.add(BatchNormalization())
  model.add(Conv2D(256, (3, 3), activation='relu', kernel_initializer='he_uniform', padding='same'))
  model.add(BatchNormalization())
  model.add(MaxPooling2D((2, 2)))
  model.add(Dropout(0.4))
  model.add(Conv2D(512, (3, 3), activation='relu', kernel_initializer='he_uniform', padding='same'))
  model.add(BatchNormalization())
  model.add(Conv2D(512, (3, 3), activation='relu', kernel_initializer='he_uniform', padding='same'))
  model.add(BatchNormalization())
  model.add(Conv2D(512, (3, 3), activation='relu', kernel_initializer='he_uniform', padding='same'))
  model.add(BatchNormalization())
  model.add(MaxPooling2D((2, 2)))





  model.add(Dropout(0.5))
  model.add(Flatten())
  model.add(Dense(512, name="feature", activation='relu', kernel_initializer='he_uniform'))
  model.add(BatchNormalization(name="norm"))
  model.add(Dropout(0.5))
  model.add(Dense(10, activation='softmax'))
  # compile model
  opt = SGD(learning_rate=0.001, momentum=0.9)
  model.compile(optimizer=opt, loss='categorical_crossentropy', metrics=['accuracy'])
  return model


deterministic_model = define_model()

hist = deterministic_model.fit(X_train, Y_train, batch_size=batch_size, epochs=nb_epoch, verbose=1,validation_data=(X_valid, Y_valid))
print('Evaluating Test Accuracy Without Acquisition')
score, acc = deterministic_model.evaluate(X_test,Y_test ,  verbose=1)
pred = deterministic_model.predict(X_test, batch_size=batch_size)
def accur(pre, obs):
  j = 0

  for i in range(pre.shape[0]):

    if np.argmax(pre, axis = 1)[i]== np.argmax(obs, axis=1)[i]:

      j = j+1

  return j/float(pre.shape[0])

all_accuracy = acc
def var_ratio(x):
  return  1 - max(x)
def max_ent(x):
  return -sum(x*np.log2(x))

# deb = []

# import time
# strt = time.time()
for i in range(acquisition_iterations):

  print('POOLING ITERATION', i)

  pool_subset = 25000
  pool_subset_dropout = np.asarray(random.sample(range(0,X_Pool.shape[0]), pool_subset))
  X_Pool_Dropout = X_Pool[pool_subset_dropout, :, :, :]
  y_Pool_Dropout = y_Pool[pool_subset_dropout]

  All_Dropout_Classes = np.zeros(shape=(X_Pool_Dropout.shape[0],1))
  print('Use trained model for test time dropout')

  for d in range(dropout_iterations):
    print ('Dropout Iteration', d)
    dropout_classes = deterministic_model.predict(X_Pool_Dropout,batch_size=batch_size, verbose=1)
    dropout_classes = np.max(dropout_classes, axis=1).reshape(dropout_classes.shape[0],)
    #dropout_classes = np.argmax(dropout_prob, axis=1).reshape(dropout_prob.shape[0],)

    dropout_classes = np.array([dropout_classes]).T
    #np.save('/Users/Riashat/Documents/Cambridge_THESIS/Code/Experiments/keras/active_learning/Acquisition_Functions/BCNN_Maximal_Uncertainty/Variation_Ratio/Dropout_Scores/'+'Dropout_Score_'+str(d)+'.npy',dropout_classes)


    All_Dropout_Classes = np.append(All_Dropout_Classes, dropout_classes, axis=1)

  Variation = np.zeros(shape=(X_Pool_Dropout.shape[0]))

  for t in range(X_Pool_Dropout.shape[0]):
    L = np.array([0])
    for d_iter in range(dropout_iterations):
      L = np.append(L, All_Dropout_Classes[t, d_iter+1])
    Predicted_Class, Mode = mode(L[1:])
    v = np.array(  [1 - Mode/float(dropout_iterations)])
    Variation[t] = v


  a_1d = Variation.flatten()
  x_pool_index = a_1d.argsort()[-Queries:][::-1]

  #store all the pooled images indexes
  x_pool_All = np.append(x_pool_All, x_pool_index)

  #saving pooled images
  # for im in range(4):
  # 	Image = X_Pool[x_pool_index[im], :, :, :]
  # 	img = Image.reshape((28,28))
  # 	sp.misc.imsave(''+'Pool_Iter'+str(i)+'_Image_'+str(im)+'.jpg', img)


  Pooled_X = X_Pool_Dropout[x_pool_index, 0:32,0:32,0:3]
  Pooled_Y = y_Pool_Dropout[x_pool_index]

  #first delete the random subset used for test time dropout from X_Pool
  #Delete the pooled point from this pool set (this random subset)
  #then add back the random pool subset with pooled points deleted back to the X_Pool set
  delete_Pool_X = np.delete(X_Pool, (pool_subset_dropout), axis=0)
  delete_Pool_Y = np.delete(y_Pool, (pool_subset_dropout), axis=0)

  delete_Pool_X_Dropout = np.delete(X_Pool_Dropout, (x_pool_index), axis=0)
  delete_Pool_Y_Dropout = np.delete(y_Pool_Dropout, (x_pool_index), axis=0)

  X_Pool = np.concatenate((X_Pool, X_Pool_Dropout), axis=0)
  y_Pool = np.concatenate((y_Pool, y_Pool_Dropout), axis=0)


  print('Acquised Points added to training set')


  X_train = np.concatenate((X_train, Pooled_X), axis=0)
  y_train = np.concatenate((y_train, Pooled_Y), axis=0)



  print('Train Model with pooled points')


  # convert class vectors to binary class matrices
  Y_train = np_utils.to_categorical(y_train, nb_classes)
  deterministic_model = define_model()

  hist = deterministic_model.fit(X_train, Y_train, batch_size=batch_size, epochs=nb_epoch, verbose=1, validation_data=(X_valid, Y_valid))

  print('Evaluate Model Test Accuracy with pooled points')

  score, acc = deterministic_model.evaluate(X_test, Y_test, verbose=0)
  print('Test score:', score)
  print('Test accuracy:', acc)
  all_accuracy = np.append(all_accuracy, acc)
  print('Use this trained model with pooled points for Dropout again')



file_name = "MC-DROPUT_var_4.pkl"
open_file = open(file_name, "wb")

pickle.dump(all_accuracy, open_file)

open_file.close()


# endd = time.time()



















































