KANG = dict(
    unperturbed_mat_file="GSM2560248_2.1.mtx",
    perturbed_mat_file="GSM2560249_2.2.mtx",
    unperturbed_cell_file="GSM2560248_barcodes.tsv",
    perturbed_cell_file="GSM2560249_barcodes.tsv",
    unperturbed_cache_file="unperturbed-cache.pkl",
    perturbed_cache_file="perturbed-cache.pkl",
    gene_name_file="GSE96583_batch2.genes.tsv",
    cell_metadata_file="muscData_kang_metadata.csv",
)

KANG_TRVAE = dict(
    counts="kang_count.h5ad",
    normalised="kang_normalized.h5ad",
)

CELLIGNER = dict(
    hgnc_file="hgnc_complete_set_7.24.2018.txt",
    tumor_file="TCGA_mat.tsv",
    cl_file="CCLE_mat.csv",
    info_file="Celligner_info.csv",
)

CATEGORY_NAME = {
    'kang': 'cell',
    'celligner': 'disease',
    'kang-trvae': 'cell',
}

CONDITION_NAME = {
    'kang': 'type',
    'celligner': 'type',
    'kang-trvae': 'type',
}

KANG_CATEGORIES = [
    "CD4 T cells",
    "CD14+ Monocytes",
    "B cells",
    "CD8 T cells",
    "NK cells",
    "FCGR3A+ Monocytes",
    "Dendritic cells",
    "Megakaryocytes",
]

KANG_TRVAE_CATEGORIES = [
    'CD14 Mono',
    'CD4 T',
    'T',
    'CD8 T',
    'B',
    'DC',
    'CD16 Mono',
    'NK'
]

UCI_INCOME = dict(features_file="uci_df.csv", metadata_file="uci_metadata_df.csv")
