#!/bin/bash

# Set common variables
export CUDA_VISIBLE_DEVICES=3
export EXPERIMENT_NAME="CONCEPT_REMOVE"
export MODEL_PATH="stabilityai/stable-diffusion-2-1-base"
export CLASS_DIR="data/class-person"

# Array of subject IDs to process
SUBJECTS=("14" "67" "112") # Add or modify subject IDs as needed
# SUBJECTS=("213" "228" "n000050") # Add or modify subject IDs as needed
# SUBJECTS=("n000068" "n000164" "n000190" "n000243") # Add or modify subject IDs as needed
# SUBJECTS=("14" "67" "112" "213" "228" "n000050" "n000068" "n000164" "n000190" "n000243") # Add or modify subject IDs as needed

for SUBJECT_ID in "${SUBJECTS[@]}"; do
    echo "Processing subject: $SUBJECT_ID"
    
    # Set subject-specific variables
    export CLEAN_TRAIN_DIR="data/$SUBJECT_ID/set_A"
    export REF_MODEL_PATH="outputs/$EXPERIMENT_NAME/${SUBJECT_ID}_REFERENCE"
    
    echo "Training DreamBooth model on set A for $SUBJECT_ID"
    accelerate launch train_dreambooth.py \
        --pretrained_model_name_or_path=$MODEL_PATH \
        --enable_xformers_memory_efficient_attention \
        --train_text_encoder \
        --instance_data_dir=$CLEAN_TRAIN_DIR \
        --class_data_dir=$CLASS_DIR \
        --output_dir=$REF_MODEL_PATH \
        --with_prior_preservation \
        --prior_loss_weight=1.0 \
        --instance_prompt="a photo of sks person" \
        --class_prompt="a photo of person" \
        --inference_prompt="a photo of sks person;a dslr portrait of sks person" \
        --resolution=512 \
        --train_batch_size=1 \
        --gradient_accumulation_steps=1 \
        --learning_rate=5e-7 \
        --lr_scheduler="constant" \
        --lr_warmup_steps=0 \
        --num_class_images=200 \
        --max_train_steps=1000 \
        --checkpointing_steps=1000 \
        --center_crop \
        --mixed_precision=bf16 \
        --prior_generation_precision=bf16 \
        --sample_batch_size=16 \
        --gradient_checkpointing \
        --set_grads_to_none

    echo "Training FSMG on set B for $SUBJECT_ID"
    export CLEAN_ADV_DIR="data/$SUBJECT_ID/set_B"
    export OUTPUT_DIR="outputs/$EXPERIMENT_NAME/${SUBJECT_ID}_ADVERSARIAL/baseline_100"
    mkdir -p $OUTPUT_DIR
    cp -r $CLEAN_ADV_DIR $OUTPUT_DIR/image_before_adding_noise
    
    accelerate launch attacks/fsmg.py \
        --pretrained_model_name_or_path="$REF_MODEL_PATH/checkpoint-1000"  \
        --enable_xformers_memory_efficient_attention \
        --train_text_encoder \
        --instance_data_dir=$CLEAN_ADV_DIR \
        --output_dir=$OUTPUT_DIR \
        --instance_prompt="a photo of sks person" \
        --resolution=512 \
        --gradient_accumulation_steps=1 \
        --max_train_steps=100 \
        --checkpointing_steps=20 \
        --center_crop \
        --pgd_alpha=5e-3 \
        --mixed_precision=bf16 \
        --gradient_checkpointing

    echo "Completed processing for $SUBJECT_ID"
    echo "----------------------------------------"
done

echo "All subjects have been processed"