# Set common variables
export CUDA_VISIBLE_DEVICES=3
export EXPERIMENT_NAME="ABLATION"
export MODEL_PATH="stabilityai/stable-diffusion-2-1-base"
export CLASS_DIR="data/class-person"
export BASE_OUTPUT_DIR="dreambooth-outputs/modelTransfer/to_TI"
# Array of subject IDs to process

PART1=( "n000050" "n000061" "n000076" "n000088" "n000097" "n000104" "n000138" "n000145" "n000154" "n000170" "n000176" "n000181" "n000187" )
PART2=( "n000215" "n000221" "n000228" "n000238" "n000057" "n000063" "n000080" "n000089" "n000098" "n000105" "n000139" "n000146" "n000161" )
PART3=( "n000171" "n000179" "n000184" "n000188" "n000217" "n000223" "n000234" "n000243" "n000058" "n000068" "n000087" "n000090" )
PART4=( "n000103" "n000110" "n000142" "n000150" "n000164" "n000172" "n000180" "n000185" "n000190" "n000220" "n000225" "n000236" )

SUBJECTS=(
"n000050" "n000061" "n000076" "n000088" "n000097" "n000104" "n000138" "n000145" "n000154" "n000170" "n000176" "n000181" "n000187" "n000215" "n000221" "n000228" "n000238"
"n000057" "n000063" "n000080" "n000089" "n000098" "n000105" "n000139" "n000146" "n000161" "n000171" "n000179" "n000184" "n000188" "n000217" "n000223" "n000234" "n000243"
"n000058" "n000068" "n000087" "n000090" "n000103" "n000110" "n000142" "n000150" "n000164" "n000172" "n000180" "n000185" "n000190" "n000220" "n000225" "n000236"
)

DATASET_ROOT=""
subdir="promptDist_1e-3"

for SUBJECT_ID in "${SUBJECTS[@]}"; do
    echo "Processing subject: $SUBJECT_ID"
    
    # Set the instance directory for current iteration
    export INSTANCE_DIR="outputs/CONCEPT_REMOVE/${SUBJECT_ID}_ADVERSARIAL/set_C/$subdir"    
    export DREAMBOOTH_OUTPUT_DIR="$BASE_OUTPUT_DIR/${SUBJECT_ID}/${subdir}"
    mkdir -p "$DREAMBOOTH_OUTPUT_DIR"
    
    # Run the training command
    accelerate launch textual_inversion.py \
        --pretrained_model_name_or_path=$MODEL_PATH \
        --train_data_dir=$INSTANCE_DIR \
        --learnable_property="object" \
        --placeholder_token="<sks-person>" \
        --initializer_token="person" \
        --resolution=512 \
        --train_batch_size=1 \
        --gradient_accumulation_steps=4 \
        --max_train_steps=1500 \
        --learning_rate=5.0e-04 \
        --scale_lr \
        --lr_scheduler="constant" \
        --lr_warmup_steps=0 \
        --output_dir=$DREAMBOOTH_OUTPUT_DIR

    echo "Running inference for $SUBJECT_ID"
    python infer_ti.py \
        --lora_path $DREAMBOOTH_OUTPUT_DIR \
        --model_path $MODEL_PATH \
        --output_dir $DREAMBOOTH_OUTPUT_DIR/results \
        --inference_prompt="a photo of sks person;a dslr portrait of sks person;a photo of sks person looking at the mirror"


    echo "Completed processing for $SUBJECT_ID"
    echo "----------------------------------------"

done

echo "All subjects have been processed"