export MODEL_PATH="stabilityai/stable-diffusion-2-1-base"
# export INSTANCE_DIR="data/n000050/set_B"
export INSTANCE_DIR="outputs/ASPL/n000050_ADVERSARIAL/noise-ckpt/50"
export CLASS_DIR="data/class-person"
export DREAMBOOTH_OUTPUT_DIR="dreambooth-outputs/adv_n000050/"

accelerate launch train_dreambooth.py \
  --pretrained_model_name_or_path=$MODEL_PATH  \
  --enable_xformers_memory_efficient_attention \
  --train_text_encoder \
  --instance_data_dir=$INSTANCE_DIR \
  --class_data_dir=$CLASS_DIR \
  --output_dir=$DREAMBOOTH_OUTPUT_DIR \
  --with_prior_preservation \
  --prior_loss_weight=1.0 \
  --instance_prompt="a photo of sks person" \
  --class_prompt="a photo of person" \
  --inference_prompt="a photo of sks person;a DSLR portrait of sks person" \
  --resolution=512 \
  --train_batch_size=1 \
  --gradient_accumulation_steps=1 \
  --learning_rate=5e-7 \
  --lr_scheduler="constant" \
  --lr_warmup_steps=0 \
  --num_class_images=200 \
  --max_train_steps=1000 \
  --checkpointing_steps=500 \
  --center_crop \
  --mixed_precision=bf16 \
  --prior_generation_precision=bf16 \
  --sample_batch_size=8 \
  --gradient_checkpointing \
  --set_grads_to_none
