import os
from train.common.config import Config
from train.iface_debug import ExternalInterfaceDebug
from train.subtask_identifier.task_builder import TaskBuilder
from train.enums import ClientEnvOption, ExecMode

META_CONFIG_FILE = 'configs/experiment/config.meta.json'
CONSENSUS = 'SSSSSSPPPPLVVNLAAA'


class Runner(object):
    def __init__(self):
        self.config = Config(META_CONFIG_FILE)
        self.config.__dict__['mode'] = ExecMode.Train
        self.config.subtask.__dict__['task'] = self.config.debug.env
        self.config.subtask.__dict__['rootdir'] = self.config.debug.subtask_rootdir
        self.config.subtask.__dict__['inputdir'] = os.path.join(self.config.debug.subtask_rootdir, self.config.debug.env)
        self.config.subtask.__dict__['outputdir'] = os.path.join(self.config.debug.subtask_outputdir, self.config.debug.env)
        self.ext_iface = ExternalInterfaceDebug(self.config)
        self.task_builder = TaskBuilder(self.config)
        self.device = self.get_device()

    def get_device(self):
        return self.ext_iface.get_device_list()[0]

    def get_env(self, option, seed=342):
        proc = self.ext_iface.make_env(num_envs=1, option=option, seed_list=[seed])
        proc.run()
        assert proc.success()
        return proc.env

    def evaluate(self, env, tasks):
        proc = self.ext_iface.evaluate_tasks(env, tasks, self.device)
        proc.run()
        assert proc.success()

    def run(self):
        tasks, _ = self.task_builder.extract_dummy_tasks(CONSENSUS)
        env = self.get_env(ClientEnvOption.Normal)
        self.evaluate(env, tasks)


# Script Execution:
# cd minerl-competition
# CUDA_VISIBLE_DEVICES=0 PYTHONPATH=. python run_scripts/experiment.py
if __name__ == "__main__":
    runner = Runner()
    runner.run()
