from train.behavioral_cloning.eval_hooks.eval_env import EvalEnv


def compile_eval_hook(dataset, dump_dir, arg_str):
    return EvalEnv(env_name="MineRLObtainDiamondDense-v0", input_space=dataset.INPUT_SPACE,
                   action_space=dataset.ACTION_SPACE, transforms=dataset.DATA_TRANSFORM, seq_len=dataset.SEQ_LENGTH,
                   trials=12, max_steps=1200, record_dir=dump_dir, argstr=arg_str, seed=123456, verbosity=1,
                   experience_recording="../deterministic_envs/recordings/diamond.p", experience_seed=875,
                   checkpoint="12-dig_down_until_found_3_cobblestones", env_server=True, n_workers=1,
                   watch_item="cobblestone")
