from train.behavioral_cloning.eval_hooks.eval_env import EvalEnv


def compile_eval_hook(dataset, dump_dir, arg_str):
    return EvalEnv(env_name="MineRLObtainDiamondDense-v0", input_space=dataset.INPUT_SPACE,
                   action_space=dataset.ACTION_SPACE, transforms=dataset.DATA_TRANSFORM, seq_len=dataset.SEQ_LENGTH,
                   trials=50, max_steps=6000, record_dir=dump_dir, argstr=arg_str, seed=123456, verbosity=1,
                   env_server=True, server_port=9999, n_workers=5, watch_item="iron_ore", experience_seed=875,
                   checkpoint="05-collect_four_logs", experience_restart_folder=True, exp_folder="tmp/experiences/iron_ore/SSSSSSSPPPPPLVNLAAAAYL")
