from PIL import Image, ImageEnhance
import cv2
import numpy as np


class ImageCorrection:

    @staticmethod
    def pil_rgb_to_cv2_gbr(img):
        open_cv_image = np.array(img)
        # Convert RGB to BGR
        return open_cv_image[:, :, ::-1].copy()

    @staticmethod
    def cv2_gbr_to_rgb_pil(img):
        img = cv2.cvtColor(img, cv2.COLOR_BGR2RGB)
        return Image.fromarray(img)

    @staticmethod
    def change_contrast(img, level):
        factor = (259 * (level + 255)) / (255 * (259 - level))

        def contrast(c):
            return 128 + factor * (c - 128)

        return img.point(contrast)

    @staticmethod
    def adjust_gamma(cv2_img, gamma=1.0):
        # build a lookup table mapping the pixel values [0, 255] to
        # their adjusted gamma values
        invGamma = 1.0 / gamma
        table = np.array([((i / 255.0) ** invGamma) * 255
                          for i in np.arange(0, 256)]).astype("uint8")
        # apply gamma correction using the lookup table
        return cv2.LUT(cv2_img, table)

    @staticmethod
    def change_contrast_multi(img, steps):
        width, height = img.size
        canvas = Image.new('RGB', (width * len(steps), height))
        for n, level in enumerate(steps):
            img_filtered = ImageCorrection.change_contrast(img, level)
            canvas.paste(img_filtered, (width * n, 0))
        return canvas

    @staticmethod
    def enhance_brightness(img, factor):
        enhancer = ImageEnhance.Brightness(img)
        return enhancer.enhance(factor)

    @staticmethod
    def adjust_sharpness(img, factor):
        enhancer_object = ImageEnhance.Sharpness(img)
        return enhancer_object.enhance(factor)

    @staticmethod
    def process(img):
        img = ImageCorrection.enhance_brightness(img, 1.6)
        img = ImageCorrection.pil_rgb_to_cv2_gbr(img)
        img = ImageCorrection.adjust_gamma(img, 1.8)
        img = ImageCorrection.cv2_gbr_to_rgb_pil(img)
        img = ImageCorrection.change_contrast_multi(img, [20])
        img = ImageCorrection.adjust_sharpness(img, 1.6)
        return img
