from train.deterministic_envs.envs.DetEnvSeed875 import CollectFourLogs
import os


def track_inventory(stage_to_start, seq_of_actions_to_perform, n_frames_to_move_randomly=0, repeat_experiment_n_times=1,
                    render=False, record=False, folder_to_store_records=None):

    if stage_to_start == 'before_craft_plank':
        if folder_to_store_records:
            e = CollectFourLogs(folder_to_store_records=os.path.join(folder_to_store_records, 'run_00'))
        else:
            e = CollectFourLogs()

        env = e.reset(render=render, record=record)
        if n_frames_to_move_randomly != 0:
            e.move_randomly_for_n_frames(n_frames=n_frames_to_move_randomly)
    else:
        raise ValueError("Check function argument 'stage_to_start', it must be a specific string.")

    all_inventory_snapshots = []

    for i in range(repeat_experiment_n_times):
        inventory_snapshots = []

        for action in seq_of_actions_to_perform:
            obs, reward, done, info = env.step(action)
            inventory_snapshots.append(obs['inventory'])

        all_inventory_snapshots.append(inventory_snapshots)

        # we have to reset the environment if we want to repeat the experiment (i.e., repeat_experiment_n_times > 1)
        # and if the loop has not yet reached the last iteration (i.e., i != repeat_experiment_n_times - 1
        if repeat_experiment_n_times > 1 and i != repeat_experiment_n_times - 1:
            if record:
                e.init_record_folder(os.path.join(folder_to_store_records, 'run_{:02d}'.format(i + 1)))
            e.reset(render=render, record=record)

    e.env.close()
    return all_inventory_snapshots
