import numpy as np

from train.deterministic_envs.envs.DetEnvSeed875 import *
from train.deterministic_envs.interface import track_inventory
from train.behavioral_cloning.datasets.experience import Experience


def test_malmo_gradle_whatever():
    e = GetUnstuck()
    e.reset()
    e.close()


def test_track_inventory():
    # define noop
    noop = {
        'attack': 0,
        'back': 0,
        'camera': np.array([0., 0.], dtype=np.float32),
        'craft': 0,
        'equip': 0,
        'forward': 0,
        'jump': 0,
        'left': 0,
        'nearbyCraft': 0,
        'nearbySmelt': 0,
        'place': 0,
        'right': 0,
        'sneak': 0,
        'sprint': 0
    }
    seq_of_actions_to_perform = []

    # fill seq with some actions to perform
    action = noop.copy()
    action['craft'] = 'planks'
    seq_of_actions_to_perform.append(action)

    action = noop.copy()
    action['right'] = 1
    seq_of_actions_to_perform.append(action)

    action = noop.copy()
    action['craft'] = 'stick'
    seq_of_actions_to_perform.append(action)

    # test one run with random movements
    inv_over_time_list = track_inventory(
        stage_to_start='before_craft_plank',
        seq_of_actions_to_perform=seq_of_actions_to_perform,
        n_frames_to_move_randomly=300
    )

    for inv_over_time in inv_over_time_list:
        assert inv_over_time[0]['planks'] == 0
        assert inv_over_time[-1]['planks'] == 4

    print('resetting env and trying random movement after reaching stage')

    # testing recording of actions and repetition of experiments
    inv_over_time_list = track_inventory(
        stage_to_start='before_craft_plank',
        seq_of_actions_to_perform=seq_of_actions_to_perform,
        n_frames_to_move_randomly=300,
        repeat_experiment_n_times=2,
        record=True,
        folder_to_store_records='tmp/minerl_tests'
    )

    for inv_over_time in inv_over_time_list:
        assert inv_over_time[0]['planks'] == 0
        assert inv_over_time[-1]['planks'] == 4


def test_pickup_table():
    e = CollectCraftingTable()

    for i in range(4):
        env = e.reset()
        assert e.get_inventory()['crafting_table'] == 1

    e.close()


def test_wooden_pickaxe():
    e = CraftAndEquipWoodenPickaxe()

    for i in range(4):
        env = e.reset()
        assert e.get_inventory()['wooden_pickaxe'] == 1

    e.close()


def test_save_experience():
    experience_recorder = Experience()
    e = GetUnstuck(experience_recorder=experience_recorder)
    env = e.reset()
    e.experience_recorder.save('recorded_experience.p')
    e.close()


def test_load_experience():
    try:
        experience = Experience().load('recorded_experience.p')
    except Exception as e:
        print(e, 'You have to run test_save_experience_first!')

    assert 'equipped_items' in experience.states[0]
    print('test of load experience complete')


def test_build_gototree_experience():
    experience_recorder = Experience()
    e = GoToTree(experience_recorder=experience_recorder)
    env = e.reset()
    e.experience_recorder.save('go_to_tree.p')
    e.close()


def test_replay_experience_on_env():
    try:
        experience = Experience().load('go_to_tree.p')
    except Exception as e:
        print(e, 'You have to run test_build_gototree_experience first!')

    e = GetUnstuck()
    env = e.reset()

    env = experience.replay_on_env(env=env)

    env.close()
    e.close()


def test_build_diamond_recording():
    experience_recorder = Experience()
    e = CollectDiamond(experience_recorder=experience_recorder)
    e.reset()
    e.experience_recorder.save('diamond.p')
    e.close()


def test_collect_diamond_recording():
    try:
        experience = Experience().load('collect_diamond.p')
    except Exception as e:
        print(e, 'You have to run test_build_diamond_recording first!')

    e = GetUnstuck()
    env = e.reset()

    env = experience.replay_on_env(env=env)

    env.close()
    e.close()


def test_plot_experience():
    experience = Experience().load('collect_diamond.p')
    experience.plot_all_observations()


if __name__ == '__main__':
    print('uncomment a specific test case')
    #test_malmo_gradle_whatever()
    #test_track_inventory()
    #test_wooden_pickaxe()
    #test_save_experience()
    #test_load_experience()
    #test_build_detenv_experience()
    #test_replay_experience_on_env()
    #test_build_diamond_recording()
    #test_collect_diamond_recording()
    #test_plot_experience()
