import torch

from train.envs.minerl_env import make_minerl
from train.behavioral_cloning.datasets.ds import ds_s32_orig_minerl_diamond_binact_softcam_48_aug0 as dataset
from train.behavioral_cloning.datasets.experience import Experience


DEVICE = torch.device('cuda' if torch.cuda.is_available() else 'cpu')


def test_experience_playback_until_cobblestone():
    n_cpu = 1
    env_id = 'MineRLObtainDiamond-v0'

    experience_recording = Experience.load('train/deterministic_envs/recordings/diamond3.p')

    env = make_minerl(
        env_id=env_id,
        n_cpu=n_cpu,
        seq_len=dataset.SEQ_LENGTH,
        transforms=dataset.DATA_TRANSFORM,
        input_space=dataset.INPUT_SPACE,
        seed=875,
        experience_recording=experience_recording,
        checkpoint='collect_one_log',
        env_server=True
    )

    state = env.reset()
    state = env.reset()
    state = env.reset()

    env.close()


if __name__ == "__main__":
    test_experience_playback_until_cobblestone()
