import torch

from train.behavioral_cloning.datasets.ds import ds_s32_orig_minerl_treechop_binact_softcam_48_aug0_fskip2 as dataset
from train.behavioral_cloning.datasets.experience import Experience
from train.behavioral_cloning.models.LightCnnLstmBinActsSoftCamSepVal import Network as net
from train.envs.minerl_env import make_minerl

DEVICE = torch.device('cuda' if torch.cuda.is_available() else 'cpu')


def investigate_experience_playback_folder(exp_folder):
    n_cpu = 1
    env_id = 'MineRLObtainDiamond-v0'
    model = net()

    model.to(DEVICE)
    print('creating env')

    env = make_minerl(
        env_id=env_id,
        n_cpu=n_cpu,
        seq_len=dataset.SEQ_LENGTH,
        transforms=dataset.DATA_TRANSFORM,
        input_space=dataset.INPUT_SPACE,
        env_server=True,
        seed=None,  # seed needs to be None when playing back a recording
        experience_recording=None,  # here, you give the above initialized experience
        checkpoint=None,  # if you want to use the last checkpoint, use this
        frame_skip=None,
        make_new_recording=False,  # this needs to be none when playing back an experience
        experience_folder=exp_folder,
        craft_equip=False)

    state = env.reset()

    env.close()
    print('done')


if __name__ == '__main__':
    investigate_experience_playback_folder('tmp/experiences/SSSSSSSPPPPP')
