import argparse
import os

from train.behavioral_cloning.datasets.ds import ds_s32_orig_minerl_treechop_binact_softcam_48_aug0_fskip2 as dataset
from train.envs.minerl_env import make_minerl


def offline_update_success_mappings(args):
    """
    Samples and replays experiences in args.exp_folder until it succeeds with replaying args.n_successes experiences.
    Updates success_mapping while doing this (success_mapping always is in tmp/experiences/success_mapping.p)

    MUST BE CALLED FROM THE MINERL-COMPETITITION CONTENT ROOT! (i.e., .../minerl-competition, such that tmp is a direct
    child folder and the path tmp/experience_replay/success_mapping.p can be found)
    """

    env = make_minerl(
        env_id=args.env_id,
        n_cpu=args.n_cpu,
        seq_len=dataset.SEQ_LENGTH,
        transforms=dataset.DATA_TRANSFORM,
        input_space=dataset.INPUT_SPACE,
        env_server=True,
        seed=None,
        experience_recording=None,
        replay_until='all',
        checkpoint=None,
        frame_skip=None,
        make_new_recording=False,
        experience_folder=args.exp_folder,
        craft_equip=False
    )

    for i in range(args.n_successes // args.n_cpu):
        state = env.reset()

    env.close()
    print('done')


if __name__ == '__main__':
    parser = argparse.ArgumentParser()
    parser.add_argument("--exp_folder", type=str, required=True)
    parser.add_argument("--n_successes", type=int, default=1)
    parser.add_argument("--n_cpu", type=int, default=1)
    parser.add_argument("--env_id", type=str, default='MineRLObtainDiamondDense-v0')

    try:
        os.listdir(os.path.join('tmp', 'experiences'))
    except FileNotFoundError as e:
        print(e)
        print('Are you sure you are executing this from the minerl-competition content root folder? ')

    args = parser.parse_args()

    offline_update_success_mappings(args)
