import logging

from train.envs.env_server import Handler, EnvServer
from train.proc.proc_base import Subprocess, repeated_run


class EnvServerProc(Subprocess):
    def __init__(self, config, num_envs):
        super(EnvServerProc, self).__init__('Environment Server', config)
        self.num_envs = num_envs

    @repeated_run
    def run(self):
        if not self.config.env.create_standalone_server:
            logging.info('Proc: No standalone server creation required!')
        else:
            logging.info('Proc: Starting server handler...')
            handler = Handler(env_name=self.config.env.env, num_envs=self.num_envs)
            logging.info('Proc: Executing startup pool...')
            handler.startup_pool()
            logging.info('Proc: Creating environment server...')
            server = EnvServer(handler=handler, host=self.config.env.host, port=self.config.env.port)
            logging.info('Proc: Starting environment server...')
            server.start_server()
        self._complete()
        logging.info('Proc: Server is up and running and listening to port connections...')
        server.listen()
