## Run multiple instances
There is systemwide synchronized environment creation, which ensure that env ports are not overlapping.
Use `training.gym_sync_create` in all training routines.

To limit the priority of the minecraft process use the enviroment wrapper `training.reprioritze_env`

Start with xvfb like:

`xvfb-run python training.py`

## Note for servers
Your homedir is NFS mounted, which results in failing gradle.
Therefore you have to start training with the additional enviroment variable like:

`GRADLE_USER_HOME="/tmp/gradle-${USER}"  python training.py`

Also you need an running VNC server, as xvfb-run doesn't work with headless nvidia

(Remark: it seems that xvfb-run does work when calling it like
  `xvfb-run --server-args="-screen 0, 1024x768x24" python training.py` )



## Old networking way to run multiple instances
This approach is not suitable as the network communication tends to fail
* Start pyro nameserver like

`pyro4-ns`
* Start global instance manager (it will launch minecraft instances) with output redirect to xvfb

`PYRO_MAX_RETIRES=3 xvfb-run python -m scripts.launch_instance_manager`
* Start training 

`MINERL_INSTANCE_MANAGER_REMOTE=True PYRO_MAX_RETRIES=3 ./training.py`

* We want the minecraft instances to use as little cpu as possible,
 so we limit the cpu time the get by using niceness, as the still would be allowed to work if the rl system is idle waiting on minecraft results.
 We cannot limit the niceness of the instance_manager as we want the python RPC part to respond quickly.
 Therefore this shell script continusly renices minecraft threads:
 
 `while true; do; renice 19 `ps -eLf|grep java.*minecraft|awk '{print $4}'`; sleep 30;done`
