import os
import importlib
import torch
import numpy as np


def import_module(module):
    module = module.replace("/", ".").strip(".py")
    module = importlib.import_module(module)
    return module


def safemean(xs):
    """ Avoid division error when calculate the mean
    (in our case if epinfo is empty returns np.nan, not return an error) """
    return np.nan if len(xs) == 0 else np.mean(xs)


def safemax(xs):
    return np.nan if len(xs) == 0 else np.max(xs)


def safemin(xs):
    return np.nan if len(xs) == 0 else np.min(xs)


def get_device(gpu, **kwargs):
    gpu = "cuda:" + gpu
    return torch.device(gpu if torch.cuda.is_available() else 'cpu')


def scale_grad_norm_(parameters, scale):
    """ Scale gradient norm for provided parameters """

    if isinstance(parameters, torch.Tensor):
        parameters = [parameters]
    parameters = list(filter(lambda p: p.grad is not None, parameters))

    scale = float(scale)

    for p in parameters:
        p.grad.data *= scale
