import logging

from train.iface import ExternalInterface
from train.task import Task


class Statement:
    def __init__(self, config, ext_iface: ExternalInterface, task: Task, task_history):
        self.config = config
        self.ext_iface = ext_iface
        self.task = task
        self.task_history = task_history
        self.result = None
        self._done = False
        logging.info('Statement: Created {} statement.'.format(self.__class__.__name__))

    def exec(self):
        raise NotImplementedError('Statement base class has no functionality implemented!')

    def success(self):
        return self._done

    def _complete(self):
        self._done = True
        logging.info('Statement: Completed {} statement'.format(self.__class__.__name__))


class SubStatement(Statement):
    def __init__(self, stmt: Statement):
        super(SubStatement, self).__init__(stmt.config, stmt.ext_iface, stmt.task, stmt.task_history)
        self.parent = stmt

    def exec(self):
        raise NotImplementedError('SubStatement base class has no functionality implemented!')
