import logging

from train.model_registry import ModelStatus
from train.statement.base_stmt import SubStatement, Statement


class PreTrainingStatement(SubStatement):
    def __init__(self, stmt: Statement):
        super(PreTrainingStatement, self).__init__(stmt)

    def exec(self):
        logging.info('Statement: Executing behavioural pre-training...')
        proc = self.ext_iface.clone_behaviour(self.task)
        self.task.update_model(proc.model, ModelStatus.GeneralBehaviourCloned)
        self.task.save()
        proc.wait()
        assert proc.success()
        self._complete()
