import logging
import os
from train.common.config import Config
from train.controller import MetaController
from train.enums import ExecMode


# All the evaluations will be evaluated on MineRLObtainDiamond-v0 environment
MINERL_GYM_ENV = os.getenv('MINERL_GYM_ENV', 'MineRLObtainDiamond-v0')
MINERL_MAX_EVALUATION_EPISODES = int(os.getenv('MINERL_MAX_EVALUATION_EPISODES', 5))

# meta controller configs
META_CONFIG_FILE = 'configs/experiment/config.meta.json'


def get_config():
    print(META_CONFIG_FILE)
    config = Config(META_CONFIG_FILE)

    if not config.debug.enabled:
        config.env.__dict__['env'] = MINERL_GYM_ENV
        config.monitor.__dict__['max_evaluation_episodes'] = MINERL_MAX_EVALUATION_EPISODES

    config.__dict__['mode'] = ExecMode.Eval
    return config


def main():
    config = get_config()
    MetaController(config).run()
