# meta controller configs
import logging
import os
from train.common.config import Config
from train.controller import MetaController
from train.enums import ExecMode


# All the evaluations will be evaluated on MineRLObtainDiamond-v0 environment
MINERL_GYM_ENV = os.getenv('MINERL_GYM_ENV', 'MineRLObtainDiamond-v0')
# You need to ensure that your submission is trained in under MINERL_TRAINING_MAX_STEPS steps
MINERL_TRAINING_MAX_STEPS = int(os.getenv('MINERL_TRAINING_MAX_STEPS', 8000000))
# You need to ensure that your submission is trained by launching less than MINERL_TRAINING_MAX_INSTANCES instances
MINERL_TRAINING_MAX_INSTANCES = int(os.getenv('MINERL_TRAINING_MAX_INSTANCES', 5))
# You need to ensure that your submission is trained within allowed training time.
# Round 1: Training timeout is 15 minutes
# Round 2: Training timeout is 4 days
MINERL_TRAINING_TIMEOUT = int(os.getenv('MINERL_TRAINING_TIMEOUT_MINUTES', 4*24*60))
# The dataset is available in data/ directory from repository root.
MINERL_DATA_ROOT = os.getenv('MINERL_DATA_ROOT', 'data/')


META_CONFIG_FILE = 'configs/experiment/config.meta.json'


def get_config():
    config = Config(META_CONFIG_FILE)

    # TODO: For the submission set the debug flag in the config to false!!!
    if config.debug.enabled:
        config.subtask.__dict__['task'] = config.debug.env
        config.subtask.__dict__['rootdir'] = config.debug.subtask_rootdir
        config.subtask.__dict__['inputdir'] = os.path.join(config.debug.subtask_rootdir, config.debug.env)
        config.subtask.__dict__['outputdir'] = os.path.join(config.debug.subtask_outputdir, config.debug.env)
    else:
        config.subtask.__dict__['task'] = MINERL_GYM_ENV
        config.subtask.__dict__['rootdir'] = MINERL_DATA_ROOT
        config.subtask.__dict__['inputdir'] = os.path.join(MINERL_DATA_ROOT, MINERL_GYM_ENV)
        config.subtask.__dict__['outputdir'] = os.path.join(config.subtask.outputdir, MINERL_GYM_ENV)

        config.env.__dict__['env'] = MINERL_GYM_ENV
        config.env.__dict__['num_env'] = MINERL_TRAINING_MAX_INSTANCES

        config.model.__dict__['data'] = MINERL_DATA_ROOT
        config.model.__dict__['training_timeout'] = MINERL_TRAINING_TIMEOUT
        config.model.__dict__['training_max_steps'] = MINERL_TRAINING_MAX_STEPS

    config.__dict__['mode'] = ExecMode.Train
    return config


def main():
    config = get_config()
    MetaController(config).run()
