from train.behavioral_cloning.datasets.minerl_dataset import MineRLDataset
from train.behavioral_cloning.spaces.action_spaces import MultiBinaryWithCameraRegression
from train.behavioral_cloning.spaces.input_spaces import SingleFrameWithBinaryActionAndContinuousCameraSequence
from train.behavioral_cloning.datasets.transforms import default_data_transform

SEQ_LENGTH = 32
INPUT_SPACE = SingleFrameWithBinaryActionAndContinuousCameraSequence(SEQ_LENGTH)
ACTION_SPACE = MultiBinaryWithCameraRegression()
DATA_TRANSFORM = default_data_transform


def compile_dataset(root, index_file, subset):
    train = True if "train" in index_file else False
    data = MineRLDataset(root=root, sequence_len=SEQ_LENGTH, train=train, prepare=False,
                         experiment="MineRLObtainDiamond-v0",
                         input_space=INPUT_SPACE,
                         action_space=ACTION_SPACE,
                         data_transform=DATA_TRANSFORM)

    return data
