import numpy as np
from train.behavioral_cloning.datasets.minerl_dataset import MineRLDataset
from train.behavioral_cloning.spaces.action_spaces import MultiBinaryBinnedCamera
from train.behavioral_cloning.spaces.input_spaces import SingleFrameWithBinaryActionAndContinuousCameraSequence
from train.behavioral_cloning.datasets.transforms import divide_pov_by_255, resize_64_to_48, to_float32, \
    build_data_processor, random_left_right_flip

SEQ_LENGTH = 32
INPUT_SPACE = SingleFrameWithBinaryActionAndContinuousCameraSequence(SEQ_LENGTH)
ACTION_SPACE = MultiBinaryBinnedCamera(bins=np.array([-20, -10, -5, -1, 1, 5, 10, 20], dtype=np.float32))
DATA_TRANSFORM = build_data_processor([resize_64_to_48, to_float32, divide_pov_by_255])
TRAIN_TRANSFORM = build_data_processor([resize_64_to_48, to_float32, divide_pov_by_255, random_left_right_flip])


def compile_dataset(root, index_file, subset):
    train = True if "train" in index_file else False
    data_transform = TRAIN_TRANSFORM if train else DATA_TRANSFORM
    data = MineRLDataset(root=root, sequence_len=SEQ_LENGTH, train=train, prepare=False,
                         experiment="MineRLObtainDiamond-v0",
                         input_space=INPUT_SPACE,
                         action_space=ACTION_SPACE,
                         data_transform=data_transform)

    return data
