import numpy as np
from train.behavioral_cloning.datasets.minerl_dataset import MineRLDataset
from train.behavioral_cloning.spaces.action_spaces import MultiBinarySoftmaxCamera
from train.behavioral_cloning.spaces.input_spaces import SingleFrameWithBinaryActionAndContinuousCameraSequence
from train.behavioral_cloning.datasets.transforms import divide_pov_by_255, resize_64_to_48, to_float32, \
    build_data_processor


SEQ_LENGTH = 32
INPUT_SPACE = SingleFrameWithBinaryActionAndContinuousCameraSequence(SEQ_LENGTH)
ACTION_SPACE = MultiBinarySoftmaxCamera(bins=np.array([-22.5, -17.5, -12.5, -7.5, -2.5, 2.5, 7.5, 12.5, 17.5, 22.5],
                                                      dtype=np.float32))
DATA_TRANSFORM = build_data_processor([resize_64_to_48, to_float32, divide_pov_by_255])


def compile_dataset(root, index_file, subset):
    train = True if "train" in index_file else False
    data = MineRLDataset(root=root, sequence_len=SEQ_LENGTH, train=train, prepare=False,
                         experiment="MineRLTreechop-v0",
                         input_space=INPUT_SPACE,
                         action_space=ACTION_SPACE,
                         data_transform=DATA_TRANSFORM)

    return data
