import numpy as np


def stack_binary_actions(action_dict, binary_actions):
    """
    Stack list of action dictionaries to binary matrix with shape (T, A)
    """

    n_actions = len(binary_actions)
    n_steps = len(action_dict[binary_actions[0]])

    action_vec = np.zeros((n_steps, n_actions), dtype=np.float32)
    for i, a in enumerate(binary_actions):
        action_vec[:, i] = action_dict[a]
    return action_vec


def stack_enum_actions(action_dict, enum_actions):
    """
    Stack list of action dictionaries to matrix with shape (T, A)
    """
    for act in enum_actions:
        if not act in action_dict:
            return None

    n_actions = len(enum_actions)
    n_steps = len(action_dict[enum_actions[0]])

    action_vec = np.empty((n_steps, n_actions), dtype=np.float32)
    for i, a in enumerate(enum_actions):
        action_vec[:, i] = action_dict[a]
    return action_vec
