from train.behavioral_cloning.eval_hooks.eval_env import EvalEnv


def compile_eval_hook(dataset, dump_dir, arg_str):
    return EvalEnv(env_name="MineRLObtainDiamondDense-v0", input_space=dataset.INPUT_SPACE,
                   action_space=dataset.ACTION_SPACE, transforms=dataset.DATA_TRANSFORM, seq_len=dataset.SEQ_LENGTH,
                   trials=12, max_steps=2400, record_dir=dump_dir, argstr=arg_str, seed=123456, verbosity=1,
                   experience_recording=None,  # not needed when providing experience replays in a folder
                   experience_seed=None,  # not needed when providing experience replays in a folder
                   checkpoint=None,  # not needed when providing experience replays in a folder
                   experience_restart_folder=True,  # this needs to be True when providing experience replay folder
                   exp_folder='tmp/experiences/SSSSSSSPPPPP',  # this needs to be set to folder with experience files
                   env_server=True, server_port=9999, n_workers=1,
                   watch_item="iron_ore")
