# -*- coding: utf-8 -*-
import json
import os

from train.common.misc import import_object, extract_named_args, try_to_number_or_bool, parse_args, dotdict


def __import_value_rec__(name, value, parent):
    if isinstance(value, str) and "import::" in value:
        conf = Config(value[len("import::"):])
        for k, v in dotdict(conf.__dict__).items():
            __import_value_rec__(k, v, parent)
            # setattr(parent, k, v)
    elif isinstance(value, str) and "class::" in value:
        value = import_object(value[len("class::"):])
        setattr(parent, name, value)
    elif isinstance(value, str) and "config::" in value:
        conf = Config(value[len("config::"):])
        conf = dotdict(conf.__dict__)
        conf['config_path'] = value[len("config::"):]
        setattr(parent, name, conf)
    elif isinstance(value, dict):
        child = dotdict(value)
        for k, v in value.items():
            __import_value_rec__(k, v, child)
        setattr(parent, name, child)
    else:
        setattr(parent, name, value)


class Config(object):
    def __init__(self, filename: str = None):
        """Create config object from json file.

        filename : optional;
            If passed read config from specified file, otherwise parse command line for config parameter and optionally
            override arguments.
        """
        args, override_args = parse_args()
        if filename is not None:
            self.config_file = filename
        else:
            if args.config is not None and len(args.config) > 0:
                self.config_file = args.config
        print("Config: {}".format(self.config_file))
        # Read config and override with args if passed
        if os.path.exists(self.config_file):
            with open(self.config_file) as f:
                self.initialize_from_json(json.loads(f.read()).items())
            # override if necessary
            if override_args is not None:
                self.override_from_commandline(override_args)
        else:
            raise Exception("Configuration file does not exist!")

    def has_value(self, name):
        return hasattr(self, name)

    def get_value(self, name, default=None):
        return getattr(self, name, default)

    def initialize_from_json(self, nv_pairs=None):
        if nv_pairs:
            for i, (name, value) in enumerate(nv_pairs):
                __import_value_rec__(name, value, self)

    def override_from_commandline(self, override_args=None):
        if override_args is not None:
            o = extract_named_args(override_args)
            for k, v in o.items():
                name = k[2:] if "--" in k else k  # remove leading --
                if v is None:
                    value = True  # assume cmd switch
                else:
                    value = v if v.startswith('"') or v.startswith("'") else try_to_number_or_bool(v)
                if "." in name:
                    names = name.split(".")
                    name = names[0]
                    if len(names) == 2:
                        if hasattr(self, names[0]):
                            curdict = getattr(self, names[0])
                        else:
                            curdict = dict()
                        curdict[names[1]] = value
                        value = curdict
                    elif len(names) == 3:
                        if hasattr(self, names[0]):
                            curdict = getattr(self, names[0])
                        else:
                            curdict = dict()

                        if names[1] in curdict:
                            subdict = curdict[names[1]]
                        else:
                            curdict[names[1]] = dict()
                            subdict = curdict[names[1]]

                        subdict[names[2]] = value
                        value = curdict
                    else:
                        raise Exception("Unsupported command line option (can only override dicts with 1 or 2 levels)")
                __import_value_rec__(name, value, self)
