from train.deterministic_envs.envs.base_env import DeterministicEnv

# SSSSSSS
# PPPPP
# L
# V
# N
# L
# AAAA
# Y
# L
# QQQ
# F
# KKK
# E


class DetEnvSeed875(DeterministicEnv):

    def __init__(self, folder_to_store_records=None, experience_recorder=None):
        super().__init__(seed=875, folder_to_store_records=folder_to_store_records, experience_recorder=experience_recorder)

    def execute_deterministic_actions(self, render, record):
        raise NotImplementedError


class GetUnstuck(DetEnvSeed875):
    """ Agent gets unstuck"""
    def __init__(self, folder_to_store_records=None, experience_recorder=None):
        super().__init__(folder_to_store_records=folder_to_store_records, experience_recorder=experience_recorder)

    def execute_deterministic_actions(self, render, record):
        self.get_unstuck()
        if self.experience_recorder:
            pass
            #self.experience_recorder.set_checkpoint('get_unstuck')


class GoToTree(GetUnstuck):
    """ Agent goes to a tree """
    def __init__(self, folder_to_store_records=None, experience_recorder=None):
        super().__init__(folder_to_store_records=folder_to_store_records, experience_recorder=experience_recorder)

    def execute_deterministic_actions(self, render, record):
        super().execute_deterministic_actions(render=render, record=record)
        self.go_to_tree(render=render, record=record)
        if self.experience_recorder:
            pass
            #self.experience_recorder.set_checkpoint('go_to_tree')

    def go_to_tree(self, render, record):
        # go to tree
        for i in range(8):
            self.turn_left(render=render, record=record)
        for i in range(14):
            self.go_forward(render=render, record=record)
        for i in range(4):
            self.strafe_left(render=render, record=record)


class CollectOneLog(GoToTree):
    """ Agent chops one log """

    def __init__(self, folder_to_store_records=None, experience_recorder=None):
        super().__init__(folder_to_store_records=folder_to_store_records, experience_recorder=experience_recorder)

    def execute_deterministic_actions(self, render, record):
        super().execute_deterministic_actions(render=render, record=record)
        self.chop_log(render=render, record=record)
        self.wait_for_n_frames(n=22, render=render, record=record)
        if self.experience_recorder:
            #print('len states:', len(self.experience_recorder.states))
            if self.experience_recorder.states[-1]['inventory']['log'] != 1:
                raise Exception("unmatching items")
            #self.experience_recorder.set_checkpoint('collect_one_log')
            self.experience_recorder.set_checkpoint('S')

    def chop_log(self, render, record):
        # chop first log
        for i in range(61):
            self.attack(render=render, record=record)


class CollectTwoLogs(CollectOneLog):
    """ Agent chops 2nd log """

    def __init__(self, folder_to_store_records=None, experience_recorder=None):
        super().__init__(folder_to_store_records=folder_to_store_records, experience_recorder=experience_recorder)

    def execute_deterministic_actions(self, render, record):
        super().execute_deterministic_actions(render=render, record=record)
        self.chop_second_log(render=render, record=record)
        self.wait_for_n_frames(n=22, render=render, record=record)
        if self.experience_recorder:
            if self.experience_recorder.states[-1]['inventory']['log'] != 2:
                raise Exception("unmatching items")

            self.experience_recorder.set_checkpoint('SS')
            #self.experience_recorder.set_checkpoint('collect_two_logs')

    def chop_second_log(self, render, record):
        for i in range(3):
            self.look_down(render, record)
        for i in range(66):
            self.attack(render, record)


class CollectThreeLogs(CollectTwoLogs):
    """ Agent chops 3rd log  """

    def __init__(self, folder_to_store_records=None, experience_recorder=None):
        super().__init__(folder_to_store_records=folder_to_store_records, experience_recorder=experience_recorder)

    def execute_deterministic_actions(self, render, record):
        super().execute_deterministic_actions(render=render, record=record)
        self.chop_third_log(render=render, record=record)
        self.wait_for_n_frames(n=22, render=render, record=record)
        if self.experience_recorder:
            if self.experience_recorder.states[-1]['inventory']['log'] != 3:
                raise Exception("unmatching items")
            self.experience_recorder.set_checkpoint('SSS')
            #self.experience_recorder.set_checkpoint('collect_three_logs')

    def chop_third_log(self, render, record):
        for i in range(3):
            self.go_forward(render, record)
        for i in range(6):
            self.look_up(render, record)
        for i in range(66):
            self.attack(render, record)


class CollectFourLogs(CollectThreeLogs):
    """ Agent chops 4th log """

    def __init__(self, folder_to_store_records=None, experience_recorder=None):
        super().__init__(folder_to_store_records=folder_to_store_records, experience_recorder=experience_recorder)

    def execute_deterministic_actions(self, render, record):
        super().execute_deterministic_actions(render=render, record=record)
        self.chop_fourth_log(render=render, record=record)
        self.wait_for_n_frames(n=22, render=render, record=record)

        #self.look_down_for_n_frames(10, render, record)
        #self.go_forward_for_n_steps(4, render, record)
        #for _ in range(4):
        #    self.go_backward(render, record)
        #self.look_up_for_n_frames(4, render, record)

        if self.experience_recorder:
            if self.experience_recorder.states[-1]['inventory']['log'] != 4:
                raise Exception("unmatching items")
            self.experience_recorder.set_checkpoint('SSSS')
            #self.experience_recorder.set_checkpoint('collect_four_logs')

    def chop_fourth_log(self, render, record):
        self.go_forward(render, record)
        for i in range(6):
            self.look_up(render, record)
        for i in range(66):
            self.attack(render, record)


class GoToSecondTree(CollectFourLogs):
    def __init__(self, folder_to_store_records=None, experience_recorder=None):
        super().__init__(folder_to_store_records=folder_to_store_records, experience_recorder=experience_recorder)

    def execute_deterministic_actions(self, render, record):
        super().execute_deterministic_actions(render=render, record=record)
        self.look_down_for_n_frames(8, render, record)
        self.turn_right_for_n_steps(9, render, record)
        self.go_forward_for_n_steps(34, render, record)
        self.turn_right_for_n_steps(2, render, record)
        self.look_down_for_n_frames(2, render, record)
        self.turn_right_for_n_steps(2, render, record)
        self.go_forward_for_n_steps(3, render, record)
        self.turn_left_for_n_steps(4, render, record)


class ChopFifthLog(GoToSecondTree):
    def __init__(self, folder_to_store_records=None, experience_recorder=None):
        super().__init__(folder_to_store_records=folder_to_store_records, experience_recorder=experience_recorder)

    def execute_deterministic_actions(self, render, record):
        super().execute_deterministic_actions(render=render, record=record)
        self.attack_for_n_frames(66, render, record)
        self.wait_for_n_frames(20, render, record)
        if self.experience_recorder:
            if self.experience_recorder.states[-1]['inventory']['log'] != 5:
                raise Exception("unmatching items")
            self.experience_recorder.set_checkpoint('SSSSS')


class ChopSixthLog(ChopFifthLog):
    def __init__(self, folder_to_store_records=None, experience_recorder=None):
        super().__init__(folder_to_store_records=folder_to_store_records, experience_recorder=experience_recorder)

    def execute_deterministic_actions(self, render, record):
        super().execute_deterministic_actions(render=render, record=record)
        self.look_down_for_n_frames(3, render, record)
        self.attack_for_n_frames(66, render, record)
        self.wait_for_n_frames(20, render, record)
        if self.experience_recorder:
            if self.experience_recorder.states[-1]['inventory']['log'] != 6:
                raise Exception("unmatching items")
            self.experience_recorder.set_checkpoint('SSSSSS')


class ChopSeventhLog(ChopSixthLog):
    def __init__(self, folder_to_store_records=None, experience_recorder=None):
        super().__init__(folder_to_store_records=folder_to_store_records, experience_recorder=experience_recorder)

    def execute_deterministic_actions(self, render, record):
        super().execute_deterministic_actions(render=render, record=record)
        self.look_up_for_n_frames(6, render, record)
        self.attack_for_n_frames(66, render, record)
        self.wait_for_n_frames(20, render, record)
        if self.experience_recorder:
            if self.experience_recorder.states[-1]['inventory']['log'] != 7:
                raise Exception("unmatching items")
            self.experience_recorder.set_checkpoint('SSSSSSS')


class CraftFirstPlank(ChopSeventhLog):
    """ Agent crafts planks """

    def __init__(self, folder_to_store_records=None, experience_recorder=None):
        super().__init__(folder_to_store_records=folder_to_store_records, experience_recorder=experience_recorder)

    def execute_deterministic_actions(self, render, record):
        super().execute_deterministic_actions(render=render, record=record)
        self.craft_planks(render=render, record=record)
        self.wait_for_n_frames(n=12, render=render, record=record)
        if self.experience_recorder:
            if self.experience_recorder.states[-1]['inventory']['planks'] != 4:
                raise Exception("unmatching items")

            self.experience_recorder.set_checkpoint('SSSSSSSP')
            #self.experience_recorder.set_checkpoint('craft_4_planks-(1_crafting_action)')


class CraftSecondPlank(CraftFirstPlank):
    """ Agent executes craft plank action twice """

    def __init__(self, folder_to_store_records=None, experience_recorder=None):
        super().__init__(folder_to_store_records=folder_to_store_records, experience_recorder=experience_recorder)

    def execute_deterministic_actions(self, render, record):
        super().execute_deterministic_actions(render=render, record=record)
        self.craft_planks(render=render, record=record)
        self.wait_for_n_frames(n=10, render=render, record=record)
        if self.experience_recorder:
            if self.experience_recorder.states[-1]['inventory']['planks'] != 8:
                raise Exception("unmatching items")
            self.experience_recorder.set_checkpoint('SSSSSSSPP')
            #self.experience_recorder.set_checkpoint('craft_8_more_planks-(2_crafting_actions)')


class CraftThirdPlank(CraftSecondPlank):
    """ Agent crafts planks """

    def __init__(self, folder_to_store_records=None, experience_recorder=None):
        super().__init__(folder_to_store_records=folder_to_store_records, experience_recorder=experience_recorder)

    def execute_deterministic_actions(self, render, record):
        super().execute_deterministic_actions(render=render, record=record)
        self.craft_planks(render=render, record=record)
        self.wait_for_n_frames(n=10, render=render, record=record)
        if self.experience_recorder:
            if self.experience_recorder.states[-1]['inventory']['planks'] != 12:
                raise Exception("unmatching items")

            self.experience_recorder.set_checkpoint('SSSSSSSPPP')
            #self.experience_recorder.set_checkpoint('craft_4_planks-(1_crafting_action)')


class CraftFourthPlank(CraftThirdPlank):
    """ Agent crafts planks """

    def __init__(self, folder_to_store_records=None, experience_recorder=None):
        super().__init__(folder_to_store_records=folder_to_store_records, experience_recorder=experience_recorder)

    def execute_deterministic_actions(self, render, record):
        super().execute_deterministic_actions(render=render, record=record)
        self.craft_planks(render=render, record=record)
        self.wait_for_n_frames(n=12, render=render, record=record)
        if self.experience_recorder:
            if self.experience_recorder.states[-1]['inventory']['planks'] != 16:
                raise Exception("unmatching items")

            self.experience_recorder.set_checkpoint('SSSSSSSPPPP')
            #self.experience_recorder.set_checkpoint('craft_4_planks-(1_crafting_action)')


class CraftFifthPlank(CraftFourthPlank):
    """ Agent crafts planks """

    def __init__(self, folder_to_store_records=None, experience_recorder=None):
        super().__init__(folder_to_store_records=folder_to_store_records, experience_recorder=experience_recorder)

    def execute_deterministic_actions(self, render, record):
        super().execute_deterministic_actions(render=render, record=record)
        self.craft_planks(render=render, record=record)
        self.wait_for_n_frames(n=12, render=render, record=record)
        if self.experience_recorder:
            if self.experience_recorder.states[-1]['inventory']['planks'] != 20:
                raise Exception("unmatching items")

            self.experience_recorder.set_checkpoint('SSSSSSSPPPPP')
            #self.experience_recorder.set_checkpoint('craft_4_planks-(1_crafting_action)')


class CraftCraftingTable(CraftFifthPlank):
    """ Agent crafts crafting table """

    def __init__(self, folder_to_store_records=None, experience_recorder=None):
        super().__init__(folder_to_store_records=folder_to_store_records, experience_recorder=experience_recorder)

    def execute_deterministic_actions(self, render, record):
        super().execute_deterministic_actions(render=render, record=record)
        self.craft_crafting_table(render=render, record=record)
        self.wait_for_n_frames(n=10, render=render, record=record)
        if self.experience_recorder:
            if self.experience_recorder.states[-1]['inventory']['crafting_table'] != 1:
                raise Exception("unmatching items")
            self.experience_recorder.set_checkpoint('SSSSSSSPPPPPL')
            #self.experience_recorder.set_checkpoint('craft_crafting_table')


class CraftStick(CraftCraftingTable):
    """ Agent crafts sticks """
    def __init__(self, folder_to_store_records=None, experience_recorder=None):
        super().__init__(folder_to_store_records=folder_to_store_records, experience_recorder=experience_recorder)

    def execute_deterministic_actions(self, render, record):
        super().execute_deterministic_actions(render=render, record=record)
        self.craft_stick(render=render, record=record)
        self.wait_for_n_frames(n=10, render=render, record=record)

        if self.experience_recorder:
            assert self.experience_recorder.states[-1]['inventory']['stick'] == 4
            self.experience_recorder.set_checkpoint('SSSSSSSPPPPPLV')
            #self.experience_recorder.set_checkpoint('craft_stick')


class PlaceCraftingTable(CraftStick):
    """ Agent places crafting table """

    def __init__(self, folder_to_store_records=None, experience_recorder=None):
        super().__init__(folder_to_store_records=folder_to_store_records, experience_recorder=experience_recorder)

    def execute_deterministic_actions(self, render, record):
        super().execute_deterministic_actions(render=render, record=record)
        self.look_down_for_n_frames(5, render, record)
        self.place_crafting_table(render=render, record=record)
        self.wait_for_n_frames(n=10, render=render, record=record)

        if self.experience_recorder:
            assert self.experience_recorder.states[-1]['inventory']['crafting_table'] == 0
            #self.experience_recorder.set_checkpoint('place_crafting_table')


class CraftAndEquipWoodenPickaxe(PlaceCraftingTable):
    """ Agent crafts and equips a wooden pickaxe """

    def __init__(self, folder_to_store_records=None, experience_recorder=None):
        super().__init__(folder_to_store_records=folder_to_store_records, experience_recorder=experience_recorder)

    def execute_deterministic_actions(self, render, record):
        super().execute_deterministic_actions(render=render, record=record)
        self.craft_wooden_pickaxe_at_nearby_crafting_table(render=render, record=record)
        self.wait_for_n_frames(n=10, render=render, record=record)
        self.equip_wooden_pickaxe(render=render, record=record)
        self.wait_for_n_frames(n=10, render=render, record=record)
        if self.experience_recorder:
            assert self.experience_recorder.states[-1]['inventory']['wooden_pickaxe'] == 1
            self.experience_recorder.set_checkpoint('SSSSSSSPPPPPLVN')
            #self.experience_recorder.set_checkpoint('craft_and_equip_wooden_pickaxe')


class CollectCraftingTable(CraftAndEquipWoodenPickaxe):
    """ Agent collects crafting table """

    def __init__(self, folder_to_store_records=None, experience_recorder=None):
        super().__init__(folder_to_store_records=folder_to_store_records, experience_recorder=experience_recorder)

    def execute_deterministic_actions(self, render, record):
        super().execute_deterministic_actions(render=render, record=record)
        self.go_forward_for_n_steps(10, render, record)
        self.look_down_for_n_frames(2, render, record)
        self.turn_left_for_n_steps(1, render, record)
        self.attack_for_n_frames(86, render, record)
        self.wait_for_n_frames(20, render, record)

        if self.experience_recorder:
            if self.experience_recorder.states[-1]['inventory']['crafting_table'] != 1:
                raise Exception("unmatching items")
            #self.experience_recorder.set_checkpoint('collect_crafting_table')
            self.experience_recorder.set_checkpoint('SSSSSSSPPPPPLVNL')


class GoToMiningLocation(CollectCraftingTable):
    """ Agent goes to nearby hill """

    def __init__(self, folder_to_store_records=None, experience_recorder=None):
        super().__init__(folder_to_store_records=folder_to_store_records, experience_recorder=experience_recorder)

    def execute_deterministic_actions(self, render, record):
        super().execute_deterministic_actions(render=render, record=record)
        for _ in range(20):
            self.go_backward(render, record)
        self.turn_right_for_n_steps(9, render, record)
        for _ in range(13):
            self.strafe_right(render, record)
        self.go_forward_for_n_steps(5, render, record)


        if self.experience_recorder:
            #self.experience_recorder.set_checkpoint('go_to_mining_location')
            pass


class DigDownUntilFound1Cobblestones(GoToMiningLocation):
    """ Agent digs down until he has collected 3 cobblestones (which are necessary to craft a stone pickaxe """

    def __init__(self, folder_to_store_records=None, experience_recorder=None):
        super().__init__(folder_to_store_records=folder_to_store_records, experience_recorder=experience_recorder)

    def execute_deterministic_actions(self, render, record):
        super().execute_deterministic_actions(render=render, record=record)
        self.dig_until_you_have_enough_stones(render, record)
        if self.experience_recorder:
            assert self.experience_recorder.states[-1]['inventory']['cobblestone'] == 1
            self.experience_recorder.set_checkpoint('SSSSSSSPPPPPLVNLA')
            #self.experience_recorder.set_checkpoint('dig_down_until_found_1_cobblestone')

    def dig_until_you_have_enough_stones(self, render, record):
        self.attack_for_n_frames(n=21, render=render, record=record)
        self.wait_for_n_frames(n=2, render=render, record=record)
        self.go_forward_for_n_steps(n=4, render=render, record=record)
        self.look_down_for_n_frames(n=1, render=render, record=record)
        self.attack_for_n_frames(n=21, render=render, record=record)
        self.wait_for_n_frames(n=2, render=render, record=record)
        self.go_forward_for_n_steps(n=7, render=render, record=record)
        self.look_down_for_n_frames(n=3, render=render, record=record)
        self.attack_for_n_frames(n=21, render=render, record=record)
        self.wait_for_n_frames(n=2, render=render, record=record)
        self.look_down_for_n_frames(n=1, render=render, record=record)
        self.attack_for_n_frames(n=21, render=render, record=record)
        self.wait_for_n_frames(n=2, render=render, record=record)
        self.go_forward_for_n_steps(n=5, render=render, record=record)
        self.look_down_for_n_frames(n=2, render=render, record=record)

        self.attack_for_n_frames(n=53, render=render, record=record)
        self.wait_for_n_frames(n=20, render=render, record=record)


class CollectSecondCobblestone(DigDownUntilFound1Cobblestones):
    def __init__(self, folder_to_store_records=None, experience_recorder=None):
        super().__init__(folder_to_store_records=folder_to_store_records, experience_recorder=experience_recorder)

    def execute_deterministic_actions(self, render, record):
        super().execute_deterministic_actions(render=render, record=record)

        self.attack_for_n_frames(n=23, render=render, record=record)
        #self.attack_for_n_frames(n=63, render=render, record=record)
        self.wait_for_n_frames(n=20, render=render, record=record)

        if self.experience_recorder:
            assert self.experience_recorder.states[-1]['inventory']['cobblestone'] == 2
            #self.experience_recorder.set_checkpoint('collect_2_more_cobblestones')
            self.experience_recorder.set_checkpoint('SSSSSSSPPPPPLVNLAA')


class CollectThirdCobblestone(CollectSecondCobblestone):
    def __init__(self, folder_to_store_records=None, experience_recorder=None):
        super().__init__(folder_to_store_records=folder_to_store_records, experience_recorder=experience_recorder)

    def execute_deterministic_actions(self, render, record):
        super().execute_deterministic_actions(render=render, record=record)

        self.attack_for_n_frames(n=33, render=render, record=record)
        self.wait_for_n_frames(n=20, render=render, record=record)

        if self.experience_recorder:
            assert self.experience_recorder.states[-1]['inventory']['cobblestone'] == 3
            #self.experience_recorder.set_checkpoint('collect_2_more_cobblestones')
            self.experience_recorder.set_checkpoint('SSSSSSSPPPPPLVNLAAA')


class CollectFourthCobblestone(CollectThirdCobblestone):
    def __init__(self, folder_to_store_records=None, experience_recorder=None):
        super().__init__(folder_to_store_records=folder_to_store_records, experience_recorder=experience_recorder)

    def execute_deterministic_actions(self, render, record):
        super().execute_deterministic_actions(render=render, record=record)


        self.look_up_for_n_frames(n=9, render=render, record=record)
        self.attack_for_n_frames(n=33, render=render, record=record)
        self.wait_for_n_frames(n=20, render=render, record=record)

        if self.experience_recorder:
            assert self.experience_recorder.states[-1]['inventory']['cobblestone'] == 4
            # self.experience_recorder.set_checkpoint('collect_2_more_cobblestones')
            self.experience_recorder.set_checkpoint('SSSSSSSPPPPPLVNLAAAA')


class CraftandEquipStonePickaxe(CollectFourthCobblestone):
    """ Agent crafts and equips a stone pickaxe """

    def __init__(self, folder_to_store_records=None, experience_recorder=None):
        super().__init__(folder_to_store_records=folder_to_store_records, experience_recorder=experience_recorder)

    def execute_deterministic_actions(self, render, record):
        super().execute_deterministic_actions(render=render, record=record)
        self.wait_for_n_frames(n=10, render=render, record=record)
        self.place_crafting_table(render=render, record=record)
        self.wait_for_n_frames(n=10, render=render, record=record)
        self.craft_stone_pickaxe_at_nearby_crafting_table(render=render, record=record)
        self.wait_for_n_frames(n=10, render=render, record=record)

        # equip stone pickaxe
        self.equip_stone_pickaxe(render=render, record=record)
        self.wait_for_n_frames(n=10, render=render, record=record)

        if self.experience_recorder:
            if self.experience_recorder.states[-1]['inventory']['crafting_table'] != 0:
                raise Exception("unmatching items")
            if self.experience_recorder.states[-1]['inventory']['stone_pickaxe'] != 1:
                raise Exception("unmatching items")
            #self.experience_recorder.set_checkpoint('craft_and_equip_stone_pickaxe')
            self.experience_recorder.set_checkpoint('SSSSSSSPPPPPLVNLAAAAY')


class CollectCraftingTableAfterStonePickaxe(CraftandEquipStonePickaxe):
    """ Agent collects the crafting table after crafting the stone pickaxe"""

    def __init__(self, folder_to_store_records=None, experience_recorder=None):
        super().__init__(folder_to_store_records=folder_to_store_records, experience_recorder=experience_recorder)

    def execute_deterministic_actions(self, render, record):
        super().execute_deterministic_actions(render=render, record=record)

        # collect crafting table
        self.attack_for_n_frames(n=81, render=render, record=record)
        self.wait_for_n_frames(n=20, render=render, record=record)

        if self.experience_recorder:
            print('we have this many crafting tables: ', self.experience_recorder.states[-1]['inventory']['crafting_table'])
            assert self.experience_recorder.states[-1]['inventory']['crafting_table'] == 1
            #self.experience_recorder.set_checkpoint('collect_crafting_table_after_crafting_stone_pickaxe')
            self.experience_recorder.set_checkpoint('SSSSSSSPPPPPLVNLAAAAYL')


class CollectCoal(CollectCraftingTableAfterStonePickaxe):
    """
    Agent goes to collect coal
    """
    def __init__(self, folder_to_store_records=None, experience_recorder=None):
        super().__init__(folder_to_store_records=folder_to_store_records, experience_recorder=experience_recorder)

    def execute_deterministic_actions(self, render, record):
        super().execute_deterministic_actions(render=render, record=record)

        self.turn_left_for_n_steps(n=9, render=render, record=record)
        self.attack_for_n_frames(n=20, render=render, record=record)
        self.wait_for_n_frames(n=2, render=render, record=record)
        self.look_down_for_n_frames(n=3, render=render, record=record)
        self.attack_for_n_frames(n=17, render=render, record=record)
        self.wait_for_n_frames(n=2, render=render, record=record)
        self.look_up_for_n_frames(n=3, render=render, record=record)
        self.go_forward_for_n_steps(n=6, render=render, record=record)
        self.attack_for_n_frames(n=17, render=render, record=record)
        self.wait_for_n_frames(n=2, render=render, record=record)
        self.look_down_for_n_frames(n=3, render=render, record=record)
        self.attack_for_n_frames(n=17, render=render, record=record)
        self.wait_for_n_frames(n=2, render=render, record=record)
        self.go_forward_for_n_steps(n=6, render=render, record=record)
        self.turn_right_for_n_steps(n=9, render=render, record=record)
        self.attack_for_n_frames(n=61, render=render, record=record)
        self.wait_for_n_frames(n=2, render=render, record=record)
        self.go_forward_for_n_steps(n=6, render=render, record=record)
        self.attack_for_n_frames(n=61, render=render, record=record)
        self.wait_for_n_frames(n=2, render=render, record=record)
        self.go_forward_for_n_steps(n=6, render=render, record=record)
        self.attack_for_n_frames(n=61, render=render, record=record)
        self.wait_for_n_frames(n=2, render=render, record=record)

        self.turn_left_for_n_steps(n=9, render=render, record=record)
        self.go_forward_for_n_steps(n=12, render=render, record=record)
        self.turn_left_for_n_steps(n=8, render=render, record=record)
        self.go_forward_for_n_steps(n=13, render=render, record=record)
        self.turn_left_for_n_steps(n=10, render=render, record=record)
        self.go_forward_for_n_steps(n=13, render=render, record=record)

        if self.experience_recorder:
            print('saving coal checkpoint')
            #self.experience_recorder.set_checkpoint('collect_coal')


class LookForIron(CollectCoal):
    """
    Diamond Ore can only be found at depth levels Y=16 and below,
    which means that we have to dig deep to get there. On the way down, we look
    for iron ore, which we mine at the end of this instance.
    """

    def __init__(self, folder_to_store_records=None, experience_recorder=None):
        super().__init__(folder_to_store_records=folder_to_store_records, experience_recorder=experience_recorder)

    def execute_deterministic_actions(self, render, record):
        super().execute_deterministic_actions(render=render, record=record)

        self.look_down_for_n_frames(n=7, render=render, record=record)
        self.attack_for_n_frames(n=220, render=render, record=record)
        self.wait_for_n_frames(n=2, render=render, record=record)
        self.look_up_for_n_frames(n=9, render=render, record=record)
        self.attack_for_n_frames(n=20, render=render, record=record)
        self.craft_stick(render=render, record=record)
        self.wait_for_n_frames(n=2, render=render, record=record)
        self.craft_torch(render=render, record=record)
        self.wait_for_n_frames(n=2, render=render, record=record)
        self.place_torch(render=render, record=record)
        self.wait_for_n_frames(n=2, render=render, record=record)
        self.look_down_for_n_frames(n=10, render=render, record=record)
        self.attack_for_n_frames(n=220, render=render, record=record)
        self.wait_for_n_frames(n=2, render=render, record=record)
        self.look_up_for_n_frames(n=9, render=render, record=record)
        self.attack_for_n_frames(n=20, render=render, record=record)
        self.wait_for_n_frames(n=2, render=render, record=record)
        self.place_torch(render=render, record=record)
        self.wait_for_n_frames(n=2, render=render, record=record)
        self.look_down_for_n_frames(n=10, render=render, record=record)
        self.attack_for_n_frames(n=103, render=render, record=record)
        self.wait_for_n_frames(n=2, render=render, record=record)
        self.look_up_for_n_frames(n=9, render=render, record=record)
        self.turn_left_for_n_steps(n=9, render=render, record=record)

        if self.experience_recorder:
            print('saving find iron checkpoint')
            #self.experience_recorder.set_checkpoint('find_iron')


class MineOneIron(LookForIron):
    """
    Agent mines 1 iron ore
    """
    def __init__(self, folder_to_store_records=None, experience_recorder=None):
        super().__init__(folder_to_store_records=folder_to_store_records, experience_recorder=experience_recorder)

    def execute_deterministic_actions(self, render, record):
        super().execute_deterministic_actions(render=render, record=record)

        # mine 1 iron ore
        self.attack_for_n_frames(n=30, render=render, record=record)
        self.wait_for_n_frames(n=10, render=render, record=record)
        self.go_forward(render=render, record=record)
        self.go_forward(render=render, record=record)
        self.wait_for_n_frames(n=10, render=render, record=record)

        if self.experience_recorder:
            print('we have this many iron:', self.experience_recorder.states[-1]['inventory']['iron_ore'])
            assert self.experience_recorder.states[-1]['inventory']['iron_ore'] == 1
            #self.experience_recorder.set_checkpoint('collect_one_iron')
            self.experience_recorder.set_checkpoint('SSSSSSSPPPPPLVNLAAAAYLQ')


class MineSecondIron(MineOneIron):
    """
    The agent mines 1 more iron ore
    """

    def __init__(self, folder_to_store_records=None, experience_recorder=None):
        super().__init__(folder_to_store_records=folder_to_store_records, experience_recorder=experience_recorder)

    def execute_deterministic_actions(self, render, record):
        super().execute_deterministic_actions(render=render, record=record)

        # mine iron
        self.look_up_for_n_frames(n=2, render=render, record=record)
        self.attack_for_n_frames(n=30, render=render, record=record)
        self.wait_for_n_frames(n=2, render=render, record=record)
        self.look_down_for_n_frames(n=2, render=render, record=record)

        self.go_forward_for_n_steps(n=4, render=render, record=record)
        self.jump(render=render, record=record)
        self.go_forward_for_n_steps(n=7, render=render, record=record)
        self.turn_right_for_n_steps(n=9, render=render, record=record)

        if self.experience_recorder:
            assert self.experience_recorder.states[-1]['inventory']['iron_ore'] == 2
            #self.experience_recorder.set_checkpoint('collect_two_more_iron')
            self.experience_recorder.set_checkpoint('SSSSSSSPPPPPLVNLAAAAYLQQ')


class MineThirdIron(MineSecondIron):
    """
    The agent mines 1 more iron ore
    """

    def __init__(self, folder_to_store_records=None, experience_recorder=None):
        super().__init__(folder_to_store_records=folder_to_store_records, experience_recorder=experience_recorder)

    def execute_deterministic_actions(self, render, record):
        super().execute_deterministic_actions(render=render, record=record)
        self.attack_for_n_frames(n=30, render=render, record=record)
        self.wait_for_n_frames(n=10, render=render, record=record)

        if self.experience_recorder:
            assert self.experience_recorder.states[-1]['inventory']['iron_ore'] == 3
            # self.experience_recorder.set_checkpoint('collect_two_more_iron')
            self.experience_recorder.set_checkpoint('SSSSSSSPPPPPLVNLAAAAYLQQQ')


class CraftFurnace(MineThirdIron):
    """
    Agent places crafting table and crafts furnace
    """
    def __init__(self, folder_to_store_records=None, experience_recorder=None):
        super().__init__(folder_to_store_records=folder_to_store_records, experience_recorder=experience_recorder)

    def execute_deterministic_actions(self, render, record):
        super().execute_deterministic_actions(render=render, record=record)
        self.look_down_for_n_frames(n=4, render=render, record=record)
        self.attack_for_n_frames(n=30, render=render, record=record)
        self.wait_for_n_frames(n=10, render=render, record=record)

        self.place_crafting_table(render=render, record=record)
        self.wait_for_n_frames(n=10, render=render, record=record)
        self.craft_furnace_at_nearby_crafting_table(render=render, record=record)
        self.wait_for_n_frames(n=10, render=render, record=record)

        if self.experience_recorder:
            assert self.experience_recorder.states[-1]['inventory']['furnace'] == 1
            #self.experience_recorder.set_checkpoint('craft_furnace')
            self.experience_recorder.set_checkpoint('SSSSSSSPPPPPLVNLAAAAYLQQQF')


class PlaceFurnace(CraftFurnace):
   """
   Agent places furnace
   """
   def __init__(self, folder_to_store_records=None, experience_recorder=None):
       super().__init__(folder_to_store_records=folder_to_store_records, experience_recorder=experience_recorder)

   def execute_deterministic_actions(self, render, record):
       super().execute_deterministic_actions(render=render, record=record)

       # place furnace
       self.place_furnace(render=render, record=record)
       self.wait_for_n_frames(n=10, render=render, record=record)

       if self.experience_recorder:
           assert self.experience_recorder.states[-1]['inventory']['furnace'] == 0
           #self.experience_recorder.set_checkpoint('place_furnace')


class SmeltFirstIron(PlaceFurnace):
    """
    We now have an inventory from which we can craft the iron pickaxe.
    """

    def __init__(self, folder_to_store_records=None, experience_recorder=None):
        super().__init__(folder_to_store_records=folder_to_store_records, experience_recorder=experience_recorder)

    def execute_deterministic_actions(self, render, record):
        super().execute_deterministic_actions(render=render, record=record)

        # smelt iron ingots
        self.smelt_iron_at_nearby_furnace(render=render, record=record)
        self.wait_for_n_frames(n=10, render=render, record=record)

        if self.experience_recorder:
            assert self.experience_recorder.states[-1]['inventory']['iron_ingot'] == 1
            #self.experience_recorder.set_checkpoint('smelt_iron')
            self.experience_recorder.set_checkpoint('SSSSSSSPPPPPLVNLAAAAYLQQQFK')


class SmeltSecondIron(SmeltFirstIron):
    """
    We now have an iventory from which we can craft the iron pickaxe.
    """

    def __init__(self, folder_to_store_records=None, experience_recorder=None):
        super().__init__(folder_to_store_records=folder_to_store_records, experience_recorder=experience_recorder)

    def execute_deterministic_actions(self, render, record):
        super().execute_deterministic_actions(render=render, record=record)

        # smelt iron ingots
        self.smelt_iron_at_nearby_furnace(render=render, record=record)
        self.wait_for_n_frames(n=10, render=render, record=record)

        if self.experience_recorder:
            assert self.experience_recorder.states[-1]['inventory']['iron_ingot'] == 2
            #self.experience_recorder.set_checkpoint('smelt_iron')
            self.experience_recorder.set_checkpoint('SSSSSSSPPPPPLVNLAAAAYLQQQFKK')


class SmeltThirdIron(SmeltSecondIron):
    """
    We now have an iventory from which we can craft the iron pickaxe.
    """

    def __init__(self, folder_to_store_records=None, experience_recorder=None):
        super().__init__(folder_to_store_records=folder_to_store_records, experience_recorder=experience_recorder)

    def execute_deterministic_actions(self, render, record):
        super().execute_deterministic_actions(render=render, record=record)

        # smelt iron ingots
        self.smelt_iron_at_nearby_furnace(render=render, record=record)
        self.wait_for_n_frames(n=10, render=render, record=record)

        if self.experience_recorder:
            assert self.experience_recorder.states[-1]['inventory']['iron_ingot'] == 3
            # self.experience_recorder.set_checkpoint('smelt_iron')
            self.experience_recorder.set_checkpoint('SSSSSSSPPPPPLVNLAAAAYLQQQFKKK')


class CraftIronPickaxe(SmeltThirdIron):
    """
    We now have an iventory from which we can craft the iron pickaxe.
    """

    def __init__(self, folder_to_store_records=None, experience_recorder=None):
        super().__init__(folder_to_store_records=folder_to_store_records, experience_recorder=experience_recorder)

    def execute_deterministic_actions(self, render, record):
        super().execute_deterministic_actions(render=render, record=record)

        # craft iron pickaxe
        self.craft_iron_pickaxe_at_nearby_crafting_table(render=render, record=record)
        self.equip_iron_pickaxe(render=render, record=record)
        self.wait_for_n_frames(n=10, render=render, record=record)
        self.equip_iron_pickaxe(render=render, record=record)
        
        if self.experience_recorder:
            assert self.experience_recorder.states[-1]['inventory']['iron_pickaxe'] == 1
            #self.experience_recorder.set_checkpoint('craft_iron_pickaxe')
            self.experience_recorder.set_checkpoint('SSSSSSSPPPPPLVNLAAAAYLQQQFKKKE')


class EquipIronPickaxe(CraftIronPickaxe):
    """
    Equip iron pickaxe
    """

    def __init__(self, folder_to_store_records=None, experience_recorder=None):
        super().__init__(folder_to_store_records=folder_to_store_records, experience_recorder=experience_recorder)

    def execute_deterministic_actions(self, render, record):
        super().execute_deterministic_actions(render=render, record=record)

        # equip iron pickaxe
        self.equip_iron_pickaxe(render=render, record=record)
        self.wait_for_n_frames(n=10, render=render, record=record)

        if self.experience_recorder:
            #self.experience_recorder.set_checkpoint('equip_iron_pickaxe')
            pass


class FindDiamond(EquipIronPickaxe):
    """
    With the iron pickaxe equipped, it's now possible to mine diamonds.
    We search for a diamond and collect it.
    """

    def __init__(self, folder_to_store_records=None, experience_recorder=None):
        super().__init__(folder_to_store_records=folder_to_store_records, experience_recorder=experience_recorder)

    def execute_deterministic_actions(self, render, record):
        super().execute_deterministic_actions(render=render, record=record)

        # go back to mining
        self.turn_right_for_n_steps(n=9, render=render, record=record)
        self.go_forward_for_n_steps(n=6, render=render, record=record)
        self.look_down_for_n_frames(n=6, render=render, record=record)

        # dig down
        self.attack_for_n_frames(n=387, render=render, record=record)
        self.wait_for_n_frames(n=2, render=render, record=record)

        # place torch
        self.look_up_for_n_frames(n=9, render=render, record=record)
        self.attack_for_n_frames(n=20, render=render, record=record)
        self.wait_for_n_frames(n=2, render=render, record=record)
        self.place_torch(render=render, record=record)
        self.wait_for_n_frames(n=3, render=render, record=record)

        # find diamond
        self.turn_left_for_n_steps(n=9, render=render, record=record)
        self.look_down_for_n_frames(n=3, render=render, record=record)
        for i in range(240):
            self.attack_forward(render=render, record=record)
        self.turn_right_for_n_steps(n=9, render=render, record=record)
        for i in range(64):
            self.attack_forward(render=render, record=record)

        if self.experience_recorder:
            #self.experience_recorder.set_checkpoint('find_diamond')
            pass


class CollectDiamond(FindDiamond):
    """
    Mine the found diamond.
    Remark: after following this trajectory, the env sets done=True!
    """

    def __init__(self, folder_to_store_records=None, experience_recorder=None):
        super().__init__(folder_to_store_records=folder_to_store_records, experience_recorder=experience_recorder)

    def execute_deterministic_actions(self, render, record):
        super().execute_deterministic_actions(render=render, record=record)

        # collect diamond
        self.attack_for_n_frames(n=10, render=render, record=record)

        for i in range(40):
            try:
                self.attack(render=render, record=record)
            except:
                pass

        if self.experience_recorder:
            #self.experience_recorder.set_checkpoint('collect_diamond')
            pass
