from train.common.config import Config
from train.enums import ClientEnvOption
from train.iface_debug import ExternalInterfaceDebug
from train.subtask_identifier.task_builder import TaskBuilder
import sys

META_CONFIG_FILE = 'configs/config.meta.json'


def create_experience_trajectory(consensus):
    print('Creating experiences for consensus', consensus)
    config = Config(META_CONFIG_FILE)
    ext_iface = ExternalInterfaceDebug(config)
    tasks, _ = TaskBuilder(config).extract_dummy_tasks(consensus)
    device_list = ext_iface.get_device_list()
    proc = ext_iface.make_env(num_envs=1, option=ClientEnvOption.Record, seed_list=[342])
    proc.run()
    assert proc.success()
    proc = ext_iface.evaluate_tasks(proc.env, tasks, device_list[0])
    proc.run()
    assert proc.success()


if __name__ == '__main__':
    create_experience_trajectory('SSSSSSSPPPP')
