import argparse
import os

from tqdm import tqdm

from train.behavioral_cloning.datasets.experience import Experience


def decorrupt_files_in_subfolders(corrupted_folder, target_folder):
    """
    Sets the corrupted attribute of all files in the corrupted_folder and each of its subfolders
    to False and copies the experience files to uncorrupted_folder.
    :param corrupted_folder: Folder with corrupted experience replay files.
    :param target_folder: Folder where de-corrupted experience replay files are copied to.
    """
    for root, subdirs, files in os.walk(corrupted_folder):
        # move files in root dir
        print('De-corrupting files in ', root)
        for file in tqdm(files):
            experience = Experience().load(os.path.join(root, file))
            # de-corrupt experience
            experience.corrupted = False
            # save to uncorrupted folder
            experience.save(file_path=os.path.join(target_folder, file))

    print('\n\n')
    print('==========================================================================')
    print('All experience files have been de-corrupted and copied to', target_folder)
    print('==========================================================================')


if __name__ == '__main__':
    parser = argparse.ArgumentParser()
    parser.add_argument("--corrupted_folder", type=str)
    parser.add_argument("--target_folder", type=str)

    args = parser.parse_args()

    decorrupt_files_in_subfolders(corrupted_folder=args.corrupted_folder, target_folder=args.target_folder)




