import argparse
from train.behavioral_cloning.datasets.experience import SeedParser


def extract_args():
    parser = argparse.ArgumentParser(description='Process some integers.')
    parser.add_argument("-x", "--experiences_root", required=False, default="experiences", help="Path to experience directory")
    parser.add_argument("-s", "--seeds_path", required=False, default="tmp/experiences/seeds.p", help="Path to seeds file")
    return parser.parse_args()


if __name__ == "__main__":
    args = extract_args()
    seeds = SeedParser.parse_seed_list(args.experiences_root)
    SeedParser.save(args.seeds_path, seeds)
    seeds = SeedParser.load(args.seeds_path)
    print(seeds)
