import argparse
import pickle


def print_sorted_success_mapping(args):
    """
    Prints the success_mapping dictionary in the order of weights that are used for sampling. Sampling is performed as
    (k + 1) / (n + 1), where k is the number of successful experience replays and n is the number of total experience
    replays. This means that an experience file with a value of [0, 0] will have the same weight as one with [10, 10]
    (i.e., 1), while an experience replay file with e.g. [0, 1] will have a weight of 0.5.
    """
    path_to_file = args.path_to_success_mapping

    with open(path_to_file, 'rb') as f:
        success_mapping = pickle.load(f)

    sorted_success_mapping = {
        k: v for k, v in sorted(success_mapping.items(),
                                key=lambda item: ((item[1][0] + 1) / (item[1][1] + 1)),
                                reverse=True)
    }

    for experience_file in sorted_success_mapping:
        print(experience_file, success_mapping[experience_file])


if __name__ == '__main__':
    parser = argparse.ArgumentParser()
    parser.add_argument("--path_to_success_mapping", type=str, default='tmp/experiences/success_mapping.p')

    args = parser.parse_args()

    print_sorted_success_mapping(args)


