import logging

from train.proc.proc_base import repeated_run
from train.proc.subtask_proc import SubtaskIdentifierProc
from train.subtask_identifier.task_builder import TaskBuilder


class SubtaskIdentifierDummyProc(SubtaskIdentifierProc):
    def __init__(self, config):
        super(SubtaskIdentifierDummyProc, self).__init__(config)
        self.si = None
        self.task_builder = TaskBuilder(self.config)
        self.consensus_encoding = None
        self.consensus_names = None
        self.list_of_tasks = []

    @property
    def consensus(self):
        return self.list_of_tasks

    @repeated_run
    def run(self):
        logging.info('Proc: Running subtask identifier dummy implementation...')

        selected_consensus = self.config.debug.subtask_consensus_selection
        consensus = self.config.debug.subtask_consensus_demos[selected_consensus]
        tasks, consensus_names = self.task_builder.extract_json_tasks(consensus)

        # set consensus information
        self.consensus_encoding = consensus
        self.consensus_names = consensus_names
        self.list_of_tasks = tasks
        logging.info("Proc: Consensus parsed: {}".format(self.consensus_names))
        # set process done flag
        self._complete()
