import logging

from train.proc.proc_base import Subprocess, repeated_run
from train.subtask_identifier.subtask_run import SubtaskIdentifier


class SubtaskIdentifierProc(Subprocess):
    def __init__(self, config):
        super(SubtaskIdentifierProc, self).__init__('Subtask', config)
        self.si = SubtaskIdentifier(self.config.subtask.task,
                                    self.config.subtask.rootdir,
                                    self.config.subtask.inputdir,
                                    self.config.subtask.outputdir,
                                    debug=self.config.debug.enabled,
                                    config=self.config)

    @property
    def consensus(self):
        return self.si.list_of_tasks

    @repeated_run
    def run(self):
        logging.info('Proc: Running subtask identifier...')
        self.si.parse_consensus()
        # set process done flag
        self._complete()
        self.si.extract()
