import logging

from train.statement.base_stmt import Statement, SubStatement


class CheckDeviceStatement(SubStatement):
    def __init__(self, stmt: Statement):
        super(CheckDeviceStatement, self).__init__(stmt)
        self.device_list = []

    def exec(self):
        self.device_list = self.ext_iface.get_device_list()
        logging.info('Statement: Compiled device list: {}'.format(self.device_list))
        self._complete()
