import logging

from train.envs.env_client import RemoteGym
from train.enums import ClientEnvOption
from train.statement.base_stmt import SubStatement, Statement


class PrepareLocalEnvironmentStatement(SubStatement):

    def __init__(self, stmt: Statement, num_envs: int, option: ClientEnvOption = ClientEnvOption.Normal,
                 seed: int = None):
        super(PrepareLocalEnvironmentStatement, self).__init__(stmt)
        self.num_envs = num_envs
        self.envs = None
        self.env_id = None
        self.seed = seed
        self.option = option

    def finalize(self):
        if self.envs is not None:
            logging.info('Statement: Closing environments.')
            self.envs.close()
        self.envs = None
        self.env_id = None

    def exec(self):
        # create environment client connectors
        logging.info('Statement: Creating {} environment clients.'.format(self.num_envs))
        proc = self.ext_iface.make_env(num_envs=self.num_envs,
                                       option=self.option,
                                       seed_list=[self.seed],
                                       env_server=False)
        proc.wait()
        self.envs = proc.env
        assert proc.success() and self.envs is not None
        self.env_id = self.config.env.env
        logging.info('Statement: {} environments up and running!'.format(self.num_envs))

        self._complete()
