from train.common.config import Config
from train.subtask_identifier.subtask_identifier import *
from train.task import Task, TaskType
import os, numpy as np, shutil
from tqdm import tqdm as tqdm
from scipy.stats import wilcoxon
import copy


def check_crafting_actions(data,list_of_triplets):
    # This function checks that every change in the inventory is correctly assign to one (or more) crafting actions
    # Sometimes the agent realises 3 crafting actions into 1. To reproduce this result, our agent has to make 3 times the crafting action.
    print('hola')

    observation_inventory = np.transpose(
        [np.array(data['observation_dict']['inventory'][d]) for d in data['observation_dict']['inventory']])

    # For different items
    ITEM = 3
    PRODUCED_ITEM = 10
    ACTION = 'action_craft'
    MINIMUM_CHANGE = 4
    WINDOW = 10
    # check for crafting log into planks

    # sum all the diff logs:
    # define a window to count produced planks
    for triplet in list_of_triplets:
        ITEM = triplet['item']
        PRODUCED_ITEM = triplet['results']
        MINIMUM_CHANGE = triplet['min']
        ACTION = triplet['action']
        mini_window = 5

        craft_plank_actions_pos = np.squeeze(np.where(data['action_dict'][ACTION] == ITEM))
        mask = np.zeros_like(data['action_dict'][ACTION])

        if isinstance(craft_plank_actions_pos, list):
            for cpos in craft_plank_actions_pos:
                mask[cpos:cpos + WINDOW] = 1
        elif isinstance(craft_plank_actions_pos, np.ndarray):
            if craft_plank_actions_pos.size > 1:
                for cpos in craft_plank_actions_pos:
                    mask[cpos:cpos + WINDOW] = 1
            elif craft_plank_actions_pos.size == 1:
                mask[craft_plank_actions_pos:craft_plank_actions_pos + WINDOW] = 1
            else:
                print('return_data')
                break
        else:
            print("Error")

        diff_planks = (observation_inventory[:-1, PRODUCED_ITEM] - observation_inventory[1:,
                                                                           PRODUCED_ITEM]) * mask[:-1]
        created_planks = np.sum(-diff_planks * (diff_planks < 0))
        craft_plank_actions = np.sum(data['action_dict'][ACTION] == ITEM)


        if created_planks > MINIMUM_CHANGE * craft_plank_actions:
            print('something missing!')
            # check for unsuccesfull craft actions
            action_positions = np.squeeze(np.where(data['action_dict'][ACTION] == ITEM))
            if action_positions.size > 1:
                # check if we got the item
                for act_pos in action_positions:
                    p_mini_window = min(act_pos + mini_window, diff_planks.size - 1)
                    produced_item_temp = np.sum(-diff_planks[act_pos:p_mini_window] * (diff_planks[act_pos:p_mini_window] < 0))
                    if produced_item_temp < MINIMUM_CHANGE:
                        print("Remove action at ",act_pos)
                        data['action_dict'][ACTION][act_pos] = 0

            missing_craft_actions = int(np.abs(created_planks - MINIMUM_CHANGE * craft_plank_actions) / MINIMUM_CHANGE)
            # get positions
            positions = np.squeeze(np.where(diff_planks < 0))
            # refine position according to window:

            refined_positions= []
            if positions.size == 1:
                refined_positions.append(positions)
            else:
                for p in positions:
                    if refined_positions == []:
                        refined_positions.append(p)
                    else:
                        if p > refined_positions[-1]+mini_window:
                            refined_positions.append(p)
            refined_positions = np.array(refined_positions)
            # get missing item in a window of 5.

            missing_item = np.zeros_like(refined_positions)
            for i,p in enumerate(refined_positions):
                # check p+mini_window
                p_mini_window = min (p+mini_window,diff_planks.size-1 )
                created_item_temp = np.sum(-diff_planks[p:p_mini_window] * (diff_planks[p:p_mini_window] < 0))
                craft_actions_temp = np.sum(data['action_dict'][ACTION][p:p_mini_window] == ITEM)
                missing_item[i] = int(np.abs(created_item_temp - MINIMUM_CHANGE * craft_actions_temp) / MINIMUM_CHANGE)

            # add craft actions until fill the missing ones
            for pos,miss in zip(refined_positions,missing_item):
                print(pos,miss)
                added_craft = 0
                iter_pos = pos
                while added_craft < miss and iter_pos < len(data['action_dict'][ACTION])-1:
                    if no_other_action(data, iter_pos):
                        print('added craft at {}'.format(iter_pos))
                        data['action_dict'][ACTION][iter_pos] = ITEM
                        added_craft += 1
                    iter_pos += 1


    return data


class SubtaskIdentifier:
    def __init__(self, tasktodo, root_dir,input_dir, output_dir, MAX_ITER = 100, debug = False, config = None,overlap=0):
        self.config = config
        self.tasktodo = tasktodo
        self.input_dir = input_dir
        self.root_dir = root_dir
        self.output_dir = output_dir
        self.consensus = None
        self.consensus_names = None
        self.MAX_ITER = MAX_ITER
        self.list_of_tasks = []
        self.DEBUG = debug
        self.rudder_samples = None
        self.concatenated_crafting_samples = None
        self.OVERLAP=overlap

        self.imitation_learning_samples = dict()
        self.rudder_learning_samples = dict()

        self.count_actions_dictionary = dict()
        # Here initialization. TODO: get from environment
        self.count_actions_dictionary['attack'] = np.zeros(1,dtype=int)
        self.count_actions_dictionary['back'] = np.zeros(1,dtype=int)
        self.count_actions_dictionary['craft'] = np.zeros(5,dtype=int)
        self.count_actions_dictionary['equip'] = np.zeros(8,dtype=int)
        self.count_actions_dictionary['forward'] = np.zeros(1,dtype=int)
        self.count_actions_dictionary['jump'] = np.zeros(1,dtype=int)
        self.count_actions_dictionary['left'] = np.zeros(1,dtype=int)
        self.count_actions_dictionary['attack'] = np.zeros(1,dtype=int)
        self.count_actions_dictionary['nearbyCraft'] = np.zeros(7,dtype=int)
        self.count_actions_dictionary['nearbySmelt'] = np.zeros(3,dtype=int)
        self.count_actions_dictionary['place'] = np.zeros(6,dtype=int)
        self.count_actions_dictionary['right'] = np.zeros(1,dtype=int)
        self.count_actions_dictionary['sneak'] = np.zeros(1,dtype=int)
        self.count_actions_dictionary['sprint'] = np.zeros(1,dtype=int)

    def already_added(self, task_to_add):
        if self.list_of_tasks == []:
            return False
        for i,t in enumerate(self.list_of_tasks):
            if t.id == task_to_add.id:
                return i

    def set_task_ready(self,key,outdir,type_extraction):
        for i,t in enumerate(self.list_of_tasks):

            if type_extraction == 'by_target':
                if t.target == key:
                    t.target_data_ready = True
                    t.data_dir_target = outdir.replace(self.root_dir,'')
                    break

            elif type_extraction == 'by_transition':
                if t.id == key:
                    t.transition_data_ready = True
                    t.data_dir_transition = outdir.replace(self.root_dir,'')
                    break
            else:
                Exception(NotImplementedError)


    def prepare_folders_and_dataset_for_subtasks(self, outputdir, type_seq='rudder', subtask='log'):

        outdir = os.path.join(outputdir, '{}_subtasks'.format(type_seq), subtask)
        shutil.copy(os.path.join(self.root_dir, "VERSION") , os.path.join(outdir, "VERSION"))
        # tempdataset = MineRLBaseDataset(root=outdir, download=False, prepare=True, experiment=self.tasktodo,
        #                             data_split=1, include_metadata=True)

        return outdir


    def extract_subtasks(self,rudder_samples,dataset, outputdir,type_seq='rudder',type_extraction=None):

        subseq_out_dir = '{}/{}_subtasks'.format(outputdir, type_seq)
        if not os.path.exists(subseq_out_dir):
            os.mkdir(subseq_out_dir)

        for key, samples in tqdm(rudder_samples.items()):
            outpath = path.join(subseq_out_dir,key,self.tasktodo)
            if path.exists(outpath):
                shutil.rmtree(outpath)
            os.makedirs(outpath)

            value,dict = extract_substask_sequences(samples, dataset,  type_seq=type_seq,
                                               outpath=outpath,count_actions_dict = copy.deepcopy(self.count_actions_dictionary) )
            # TODO: these if / else have to be replace for try / except. Right now does not make sense
            if value:
                outdir = self.prepare_folders_and_dataset_for_subtasks( outputdir, type_seq=type_seq, subtask=key)
                if outdir:
                    # print the metadata file
                    with open(os.path.join(outdir, 'action_info.json'), 'w') as o_f:
                        for k,v in dict.items():
                            if type(dict[k]) == np.ndarray:
                                dict[k] = v.tolist()
                            else:
                                dict[k] = int(v)
                        json.dump(dict, fp=o_f)
                    self.set_task_ready(key,outdir,type_extraction=type_extraction)
                else:
                    print("Failed to get the data ready for {}".format(key))
            else:
                print("Failed to extract subtask {}".format(key))


    def run_statistics(self):
        print("Quantile ------------------------------------")
        print(['{:.1f} '.format(q) for q in np.arange(0, 1, 0.1)])
        all_samples = self.all_samples
        n_actions = dict()
        quantiles = dict()
        for k, v in all_samples.items():
            n_actions[k] = []
            quantiles[k] = []
            for element in v:
                n_actions[k].append(np.copy(element[3]))
            for q in range(0, 11):
                quantiles[k].append(np.quantile(n_actions[k], q / 10))
            print('{} ----------------'.format(k))
            print(['{:.1f}'.format(q) for q in quantiles[k]])

        return quantiles


    def count_all_actions(self,file, start, end):

        name = os.path.split(os.path.split(file)[0])[-1]
        my_data = self.dataset[name]

        files = [f for f in my_data['action_dict'] if 'camera' not in f ]
        actions = my_data['action_dict'][files[0]].astype(np.float64)

        for i in range(1, len(files)):
            if actions.shape == my_data['action_dict'][files[i]].shape:
                actions += my_data['action_dict'][files[i]]
        actions = np.minimum(actions, 1)
        return int(np.sum(actions[start:end]))

    def run(self):
        #logging.info('Subtask: Creating alignment and extracting subtasks')
        self.parse_consensus()
        self.extract()
        #logging.info('Subtask: Extraction is done!')
    def clean_the_data(self,list_of_triplets):

        # check_crafting_actions(sa_dict, list_of_triplets)
        for k,v in self.dataset.items():
            self.dataset[k] = check_crafting_actions(v,list_of_triplets)




        return True


    def parse_consensus(self):

        self.dataset = prepare_data(rootdir=self.root_dir,prepare=True)
        top_n = -1  # We take all sequences
        # tasktodo = 'MineRLObtainIronPickaxe-v0'
        start_time = time.time()

        spaces_mapper = SpacesMapper(self.tasktodo)
        s_equip, s_inv, s_act = spaces_mapper.equipped, spaces_mapper.inventory, spaces_mapper.actions

        ##############################################################################
        if not os.path.exists(self.output_dir):
            os.makedirs(self.output_dir)
        else:
            shutil.rmtree(self.output_dir)
            os.makedirs(self.output_dir)


        # clean data transitions
        list_of_triplets = get_triplets(self.dataset)
        self.clean_the_data(list_of_triplets)

        # inventory_changes, subtask_dict, rewards = make_lookup_dict_from_raw(input_dir=input_dir, output_dir=output_dir,make_files=True)
        if not os.path.exists(os.path.join(self.output_dir, 'inventory_changes.npz')):
            inventory_changes, subtask_dict, rewards, self.dataset = make_lookup_dict_from_raw(dataset = self.dataset, input_dir=self.input_dir,
                                                                                 output_dir=self.output_dir,
                                                                                 make_files=True, debug=self.DEBUG)

        inventory_changes = np.load(os.path.join(self.output_dir, 'inventory_changes.npz'))
        rewards = np.load(os.path.join(self.output_dir, 'rewards.npz'))

        aa_dict = OrderedDict({
            0: "G", 1: "A", 2: "L", 3: "M",
            4: "F", 5: "W", 6: "K", 7: "Q", 8: "E", 9: "S",
            10: "P", 11: "V", 12: "I", 13: "C",
            14: "Y", 15: "H", 16: "R", 17: "N", 18: "D", 19: "T"
        })
        aa_to_item = {aa_dict[aa]: item for aa, item in zip(range(0, len(s_inv)), s_inv)}

        # Rewards
        top_n_seq, _, fastafile = create_fasta_sequences(aa_dict, rewards, inventory_changes, outdir=self.output_dir,
                                                         top_n=top_n, exclude=None)
        # Extract rewards for milestones from the sequences
        seq_deltas = inventory_changes[top_n_seq.index[0]]
        delta_pos, delta_ids = seq_deltas
        seq_rewards = rewards[top_n_seq.index[0]]
        env_rewards = seq_rewards[delta_pos - 1]
        env_rewards = env_rewards[env_rewards > 0]
        env_reward_ids = delta_ids[seq_rewards[delta_pos - 1] > 0]
        reward_dict = {s_inv[env_reward_ids[i]]: env_rewards[i] for i in range(len(env_reward_ids))}
        reward_dict_ids = {env_reward_ids[i]: env_rewards[i] for i in range(len(env_reward_ids))}

        # read sequence

        my_sequences, ids, ids_int = read_sequences(fasta_file=fastafile)

        milestones_seqs, my_clustered_seqs, my_clustered_ids, my_clustered_ids_int = get_first_milestone_appearance(
            my_sequences, ids)
        #####################################
        # only test. this is wrong.
        list_of_seq = []
        for id,seq,idx in zip(my_clustered_ids,my_clustered_seqs,my_clustered_ids_int):
            my_seq = dict()
            my_seq['id'] = id
            my_seq['seq'] = seq
            my_seq['len'] = len(seq)
            my_seq['idx'] = idx
            list_of_seq.append(my_seq)

        newlist = sorted(list_of_seq, key=lambda k: k['len'])


        my_clustered_seqs = [ myseq['seq'] for myseq in newlist[:20] ]
        my_clustered_ids = [ myseq['id'] for myseq in newlist[:20] ]
        my_clustered_ids_int = [ myseq['idx'] for myseq in newlist[:20] ]

        ranking_by_name = dict()
        for i, seq in enumerate(newlist):
            name = seq['id'].replace('>', '').replace('\n', '').split('|')[0]
            ranking_by_name[name] = i
            #########################





        # master alignment
        master_seq, master_ids, score_file = get_alignment(aa_dict, reward_dict_ids, my_clustered_seqs,
                                                           my_clustered_ids,
                                                           my_clustered_ids_int, milestones_seqs, self.output_dir)

        # get consensus (mayority voting)
        self.consensus, list_of_consensus = compute_consensus_boostraping(aa_dict, reward_dict_ids, my_clustered_seqs, my_clustered_ids,
                                                       milestones_seqs,
                                                       fasta_file=fastafile,
                                                       score_file=score_file,
                                                       outfile=os.path.join(self.output_dir, 'consensus.fasta'),
                                                       output_dir=self.output_dir,
                                                       MAX_ITER=self.MAX_ITER, debug=self.DEBUG)

        #############################################################################################################

        # let's alignm the consensus with every sequence
        # get_alignment(output_dir,my_clustered_seqs, my_clustered_ids, milestones_seqs)

        print(self.consensus)
        self.consensus = get_consensus(list_of_consensus, threshold=0.2)
###############################################################################################################################
        ###############################################################################################################################
        consensus_positions_in_seq = dict()
        # we go over all sequences in newlist (sequences with the same strategy in terms of milestones

        for i,_ in tqdm(enumerate(newlist)):

            sequence_to_align = newlist[i]['seq']
            id_to_align = newlist[i]['id']

            id_cleaned =  id_to_align.replace('>','').replace('\n','').split('|')[0]
            id_to_align_inventory_change = os.path.join(self.root_dir,self.tasktodo,id_cleaned,'rendered.npz')

            consensus_positions_in_seq[id_cleaned]=np.zeros(len(self.consensus),dtype=int)

            temp_seq = [sequence_to_align,self.consensus]
            temp_id = [id_to_align,'>consensus\n']
            temp_idx = [newlist[i]['id'],0]
            temp_master_seq, temp_master_ids, _ = get_alignment(aa_dict, reward_dict_ids, temp_seq, temp_id,
                                                                temp_idx, milestones_seqs, self.output_dir)
            consensus = ''.join(temp_master_seq[0]).replace('\n','').replace('T','')
            sequence_to_align = ''.join(temp_master_seq[1]).replace('\n','').replace('T','')
            # get the position of the consensus
            consensus_index = 0
            sequence_index = 0
            for j,s in enumerate(sequence_to_align):
                if s == self.consensus[consensus_index]:
                    pos = inventory_changes[id_to_align_inventory_change][0][sequence_index]
                    consensus_positions_in_seq[id_cleaned][consensus_index] = pos
                    consensus_index += 1
                    sequence_index += 1
                elif s == '-':
                    consensus_positions_in_seq[id_cleaned][consensus_index] = -1
                    consensus_index += 1
                else:
                    sequence_index += 1
                if consensus_index == len(self.consensus):
                    break
###############################################################################################################################
###############################################################################################################################
        self.consensus_names = [aa_to_item[f] for f in self.consensus]

        # get transitions from consensus:
        all_transitions = dict()
        for i,c in enumerate(self.consensus_names):
            if i == 0:
                last = 'None'
            all_transitions[last+'-'+c] = []
            last = c
        all_transitions[last + '-End'] = []

        rudder_transitions_count = dict()
        for f in inventory_changes.files:
            rudder_transitions_count[f] = dict()
            for k in all_transitions.keys():
                rudder_transitions_count[f][k] = 0
                #    self.count_all_actions(f, start, end)

        for name,list in consensus_positions_in_seq.items():
            # solve the None-Start transitions
            start = 0
            pre = 'None'
            i=0
            while list[i] == -1:
                i += 1
            end = list[i]
            last = self.consensus_names[0]
            file = os.path.join(self.root_dir,self.tasktodo,name,'rendered.npz')
            n_actions = self.count_all_actions(file, start, end)
            ranking = ranking_by_name[name]
            #print(start, end,n_actions)
            cur_item_name = pre+'-'+last
            all_transitions[cur_item_name].append([file, start, end, n_actions, rudder_transitions_count[file][cur_item_name],ranking])
            rudder_transitions_count[file][cur_item_name] += 1

            for i in range( 0,len(list)):
                if list[i] >= 0:
                    pre = self.consensus_names[i]
                    start = list[i]
                    if i<(len(list)-1):
                        j=1
                        # TODO check this here, when enters the Break. In my example it never entered
                        break_ = 0
                        while list[i+j] == -1:
                            if i<(len(list)-1):
                                j += 1
                            else:
                                print("Break")
                                break_ = 1
                                break
                        if break_:
                            last = 'End'
                            end = -1
                        else:
                            if i+j < len(self.consensus_names):
                                last = self.consensus_names[i+j]
                                end = list[i+j]
                            else:
                                last = 'End'
                                end = list[i + j]
                    else:
                        last = 'End'
                        end = -1

                    cur_item_name = pre+'-'+last
                    #print(cur_item_name,i, last)
                    file = os.path.join(self.root_dir, self.tasktodo, name, 'rendered.npz')
                    n_actions = int(self.count_all_actions(file, start, end))
                    ranking = ranking_by_name[name]
                    #print(start,end,n_actions)
                    if cur_item_name not in all_transitions.keys():
                        print("{} not in all transitions".format(cur_item_name))
                    else:
                        all_transitions[cur_item_name].append([file, int(start), int(end), n_actions, rudder_transitions_count[file][cur_item_name],ranking])
                        rudder_transitions_count[file][cur_item_name] += 1


        self.all_samples = all_transitions



        # get crafting items
        n_actions_transition = dict()
        for k,v in self.all_samples.items():
            n_actions_transition[k] = []
            for seq in v:
                if seq[5]<20: ## Look only the 20 shortest sequences
                    n_actions_transition[k].append(seq[3])
        quantiles = dict()
        for k,v in n_actions_transition.items():
            quantiles[k] = np.quantile(v, q=0.1)

        # get the median length of sequences
        median_per_task= dict()
        length_per_task = dict()
        for k, v in self.all_samples.items():
            length_per_task[k] = []
            for value in v:
                length_per_task[k].append(value[2]-value[1])
            median_per_task[k] = np.quantile(length_per_task[k],q=0.5)

        # get transitions in consensus
        list_of_transitions_in_consensus = []
        for k,v in all_transitions.items():
            list_of_transitions_in_consensus.append(k)


        # create list of tasks
        self.list_of_tasks = []
        for tra in list_of_transitions_in_consensus:
            if quantiles[tra] > 20:
                task_type = TaskType.Learning
            else:
                task_type = TaskType.Imitation
            id = tra
            target = tra.split('-')[-1]
            median_task_steps = median_per_task[tra]
            # TODO check ruuder_subtask
            data_dir = os.path.join(os.path.split(self.output_dir)[-1], 'rudder_subtask')
            data_dir_transition = os.path.join(data_dir, self.config.subtask.dir_transition)
            data_dir_target = os.path.join(data_dir, self.config.subtask.dir_target)

            task_to_add = Task(config=self.config, id=id, target=target, task_type=task_type)
            task_to_add.data_dir_transition = data_dir_transition
            task_to_add.data_dir_target = data_dir_target
            if id == 'log':
                task_to_add.data_id = 'MineRLTreechop-v0'
            else:
                task_to_add.data_id = self.tasktodo
            task_to_add.median_task_steps = median_task_steps

            if self.already_added(task_to_add):
                task_to_add_index = self.already_added(task_to_add)
                self.list_of_tasks.append(self.list_of_tasks[task_to_add_index])
            else:
                self.list_of_tasks.append(task_to_add)

        # TODO: check when task is ready -> data_ready = True
        #logging.info("Subtask: Consensus took {} seconds".format(time.time() - start_time))

    def extract(self):
        start_time = time.time()

        dataset = self.dataset
        # TODO: Quitar! Remove! Uncoment this line
        # start new counter
        rudder_transitions_count = dict()
        for k, v in self.all_samples.items():
            for value in v:
                rudder_transitions_count[value[0]] = dict()


        for k,v in self.all_samples.items():
            name = k.split('-')[-1]
            for value in v:
                rudder_transitions_count[value[0]][name] = 0

        temp_rudder_samples = dict() # copy.deepcopy(self.rudder_learning_samples)
        for k,v in self.all_samples.items():
            name = k.split('-')
            temp_rudder_samples[name[-1]] = []
        for k, v in self.all_samples.items():
            name = k.split('-')
            for element in self.all_samples[k]:
                element[4] = rudder_transitions_count[element[0]][name[-1]]
                temp_rudder_samples[name[-1]].append(element)
                rudder_transitions_count[element[0]][name[-1]] += 1


        by_target_path = os.path.join(self.output_dir,self.config.subtask.dir_target)
        by_transitions_path = os.path.join(self.output_dir,self.config.subtask.dir_transition)
        if not os.path.exists(by_target_path):
            os.mkdir(by_target_path)
        if not os.path.exists(by_transitions_path):
            os.mkdir(by_transitions_path)

        self.extract_subtasks(temp_rudder_samples, dataset,  by_target_path,
                              type_seq='rudder',type_extraction='by_target')
        self.extract_subtasks(self.all_samples, dataset,  by_transitions_path,
                              type_seq='rudder',type_extraction='by_transition')

        # subtastks_to_extract = dict()
        # for t in self.list_of_tasks:
        #     if t.task_type == TaskType.Imitation:
        #         if t.id not in subtastks_to_extract.keys():
        #             subtastks_to_extract[t.id] = []
        #         subtastks_to_extract[t.id] = self.all_samples[t.id].copy()
        #
        # self.extract_subtasks(subtastks_to_extract, dataset, by_transitions_path,
        #                               type_seq='rudder', type_extraction='by_transition')




       # logging.info("Subtask: Extracting took {} seconds".format(time.time() - start_time))


if __name__ == "__main__":
    debug = False
    task = 'MineRLObtainDiamond-v0'
    overlap = 0
    if debug:
        root_dir = 'tmp/mineRL/MineRLObtainDiamond-v1_small2'
        MAX_ITER = 2
    else:

        root_dir = 'tmp/mineRL/MineRLObtainDiamond-v1_new'
        MAX_ITER = 20
    inputdir = '{}/{}'.format(root_dir, task)
    if debug:
        outputdir = 'tmp/extract/test_I/{}'.format(task)
    else:
        ####################################################################################33
        outputdir = 'tmp/extract/Test_IX/{}'.format(task)

    if os.path.exists(outputdir):
       os.system('rm -r {}'.format(outputdir))

    config = Config('configs/experiment/config.meta.json')

    si = SubtaskIdentifier(task, root_dir, inputdir, outputdir,MAX_ITER=MAX_ITER, debug = debug, overlap= overlap, config=config)
    si.run()
