import natsort
import pandas as pd
import os
import argparse



dataset_dir = '/home/v1-2080/xjy/python_light_good/classify_frame/data/sign_mnist_y128_img'

def func(dataset_dir):
    data_dict = {}
    dirs = os.listdir(f'{dataset_dir}/train/x')
    dirs = natsort.natsorted(dirs)

    for dir in dirs:
        idx = dirs.index(dir)
        data_dict.update({dir:idx})

    print(data_dict)


    train_data = {'x':[],'y':[],'label':[]}
    test_data = {'x':[],'y':[],'label':[]}


    for dir in dirs:
        imgs = os.listdir(os.path.join(f'{dataset_dir}/train/x',dir))
        for img in imgs:
            img_name = img.split('.')[0]
            x_abs_path = os.path.abspath(f'{dataset_dir}/train/x/{dir}/{img_name}.png')
            x0_abs_path = os.path.abspath(f'{dataset_dir}/train/y/{dir}/{img_name}.png')
            train_data['x'].append(x_abs_path)
            train_data['y'].append(x0_abs_path)
            train_data['label'].append(dirs.index(dir))

    for dir in dirs:
        imgs = os.listdir(os.path.join(f'{dataset_dir}/test/x',dir))
        for img in imgs:
            img_name = img.split('.')[0]
            x_abs_path = os.path.abspath(f'{dataset_dir}/test/x/{dir}/{img_name}.png')
            x0_abs_path = os.path.abspath(f'{dataset_dir}/test/y/{dir}/{img_name}.png')
            test_data['x'].append(x_abs_path)
            test_data['y'].append(x0_abs_path)
            test_data['label'].append(dirs.index(dir))

    df_train = pd.DataFrame(train_data)
    df_test = pd.DataFrame(test_data)

    df_train.to_csv(f'{dataset_dir}/train_data.csv',index=False)
    df_test.to_csv(f'{dataset_dir}/test_data.csv',index=False)


if __name__=='__main__':
    parser = argparse.ArgumentParser(description='Create a dataset csv file')
    parser.add_argument('--dataset_dir', required=True, type=str)
    args = parser.parse_args()
    func(args.dataset_dir)
