#! /bin/bash

for var in RacoNetClassify
do

export CUDA_VISIBLE_DEVICES=1
export OMP_NUM_THREADS=4
torchrun  --nproc_per_node 1 train.py \
    --model $var \
    --dataset_name "[dataset]" \
    --train_dataset "data/[dataset]/train_data.csv" \
    --test_dataset "data/[dataset]/test_data.csv" \
    --in_channels 3 \
    --in_size 256 \
    --classify_num 24 \
    --batch_size 16 \
    --lr 0.0005 \
    --epochs [number] \
    --start_epoch 0 \
    --device "cuda:1" \
    --continue_train "false" \
    --checkpoint "[GIAO weight]" \
    --parameter "[RacoNet weight]" \
    --checkpoints_dir "checkpoins"

done

