import torch
from torchvision.utils import save_image
import matplotlib.pyplot as plt

def generate_images(tensors, path, titles):
    _, axs = plt.subplots(tensors.shape[0]//10, 10, figsize=(20, tensors.shape[0]//5))

    for i in range(len(tensors)):
        ax = axs[i // 10, i % 10]
        ax.imshow(tensors[i].squeeze().numpy(),cmap='gray')
        title_str = str(titles[i])
        if len(title_str) == 1:
            title_str = '0'+ title_str
        ax.set_title(title_str)
        ax.axis('off')

   
    plt.tight_layout()
    plt.savefig(path)