Environment Setup
Our experiments were conducted on an NVIDIA GeForce RTX 3070 GPU. The software environment included the following:

JAX version 0.4.33
JAXLIB version 0.4.33
PyTorch version 2.0.1+cu117
CUDA version 11.5
CUDNN version 8.9.2
Python 3.10
Dataset Generation
Please follow these steps to generate the datasets:

Run the following command to derive the MNIST double-digit dataset:

python3 dataprocess/generate_mnist2d.py
Run the following command to train the ResNet18 as the digit classifier, which will be used to evaluate the training and testing accuracies of the generated digits:

python3 dataprocess/classifier.py
Model Testing
After generating the datasets, you can run different models to test the performance of the Score Neural Operator under various settings.

The two most important models are:

2DGMM.py (for our 2D-GMM experiment)
SNO_prototype_latent.py (for our MNIST double-digit dataset, which has the best performance)
Additionally, SNO_prototype_fewshot.py is used to generate samples from the test distribution using only a few test samples. This should be run after executing python3 SNO_prototype_latent.py as it requires the trained weights from that model.

