# CerCE: Towards Certifiable Continual Learning
Continual Learning (CL) aims to develop models capable of learning sequentially without catastrophic forgetting of previous tasks. However, most existing approaches rely on heuristics and lack formal guarantees, limiting their applicability in safety-critical domains. We introduce Certifiable Continual LEarning (CerCE), a CL framework that provides provable certificates of non-forgetting during training. CerCE leverages Linear Relaxation Perturbation Analysis (LiRPA) to reinterpret weight updates as structured perturbations, deriving constraints that guarantee the preservation of past knowledge. We formulate CL as a constrained optimization problem and propose practical optimization strategies, including gradient projection and Lagrangian relaxation, to efficiently satisfy these certification constraints. Furthermore, we connect our approach to PAC-Bayesian generalization theory, showing that CerCE naturally leads to tighter generalization bounds and reduced memory overfitting. Experiments on standard benchmarks and safety-critical datasets demonstrate that CerCE achieves strong empirical performance while uniquely offering formal guarantees of knowledge retention, marking a significant step toward verifiable continual learning for real-world applications.

## Getting Started
Create a new a environment and install the dependencies
```
conda create -n cerce python==3.11
pip install -r requirements.txt
cd auto_LiRPA
pip install -e .
```
Following the above lines should lead to a working environment, if setting up in your own way keep the following in mind:
- Use numpy version<2
- Make sure your auto_LiRPA installation has the following line commented out as it is bugged:
'auto_LiRPA/auto_LiRPA/operators/linear.py: line 60':
```
# self.share_alphas = options.get('matmul', {}).get('share_alphas', False)
```

## Pre-processing RUARobot and Medical datasets

Obtain the data from [RUARobot](https://github.com/DNGros/R-U-A-Robot) or [Medical](https://github.com/GavinAbercrombie/medical-safety) and move to relevant path, then modify the paths and run the code in `data/process_ruarobot.py` and `data/process_medical.py` respectively.

## Running Experiments

You can use the following lines to run the experiments of the Image Datasets. Make sure to use `--embed-img` with CIFAR10/100 in order to used the pretrained and frozen embedding, and to use `--all-samples` to include the buffer samples in the cross entropy loss.

```
### MNIST
python main.py --train-type cerce --dataset mnist --track-buffer --lr 0.1 --gamma 0.002 --lam 0.01 --n-tasks 10 --hdim 400 --epochs 1 --batch-size 32 --mini-batchsize 32 --num-runs 10 --buffer-size 500 --all-samples

### FashionMNIST
python main.py --train-type cerce --dataset fmnist --track-buffer --wandb --wandb-project VCL-lpr --lr 0.1 --gamma 0.002 --lam 0.01 --n-tasks 10 --hdim 400 --epochs 1 --batch-size 32 --mini-batchsize 32 --num-runs 10 --buffer-size 500 --all-samples

### CIFAR10
python main.py --dataset cifar10 --embed-img --lr 0.01 --hdim 400 --train-type cerce --epochs 50 --batch-size 32 --mini-batchsize 32 --lam 0.01 --gamma 0.001 --weight-decay 0.001 --all-samples --num-runs 10 --buffer-size 500

### CIFAR100
python main.py --dataset cifar100 --embed-img --lr 0.01 --hdim 400 --train-type cerce --epochs 50 --batch-size 32 --mini-batchsize 32 --lam 0.01 --gamma 0.001 --weight-decay 0.001 --all-samples --num-runs 10 --buffer-size 500

```

## Used libraries
This library uses
- [AutoLiRPA](https://github.com/Verified-Intelligence/auto_LiRPA): License in ./auto_LiRPA
- Buffer code from [Mammoth](https://github.com/aimagelab/mammoth/tree/master): License in mammoth_lisence
