from continuum.datasets import InMemoryDataset
import numpy as np
import os
from sklearn.model_selection import train_test_split
from continuum.tasks import TaskType

def get_medical_datasets(path, args, num_tasks=5):
    ser_emb = np.load(os.path.join(path,'medical/serious_emb.npy')).squeeze()
    non_ser_emb = np.load(os.path.join(path,'medical/non_serious_emb.npy')).squeeze()
    neg_emb = np.load(os.path.join(path,'medical/neg_emb.npy')).squeeze()

    x_embs = np.concatenate((ser_emb, non_ser_emb, neg_emb))
    y_embs = np.concatenate((np.ones(ser_emb.shape[0], dtype=np.int64), np.ones(non_ser_emb.shape[0], dtype=np.int64), np.zeros(neg_emb.shape[0], dtype=np.int64)))
    if args.train_type == 'intercontinet':
        x_embs[x_embs < 0] = 0 
    x_train, x_test, y_train, y_test = train_test_split(x_embs, y_embs, test_size=0.2, random_state=args.seed)
    dataset_train = InMemoryDataset(x=x_train, y=y_train, data_type=TaskType.TENSOR)
    dataset_test = InMemoryDataset(x=x_test, y=y_test, data_type=TaskType.TENSOR)

    return dataset_train, dataset_test
