from continuum.datasets import InMemoryDataset
import numpy as np
import os
from sklearn.cluster import KMeans, SpectralClustering
from sklearn.mixture import GaussianMixture
from continuum.tasks import TaskType

def get_RUARobot_datasets(path, args, num_tasks=5):
    pos_emb = np.load(os.path.join(path,'ruarobot/pos_emb.npy')).squeeze()
    amb_emb = np.load(os.path.join(path,'ruarobot/amb_emb.npy')).squeeze()
    neg_emb = np.load(os.path.join(path,'ruarobot/neg_emb.npy')).squeeze()
    pos_test_emb = np.load(os.path.join(path,'ruarobot/pos_test_emb.npy')).squeeze()
    amb_test_emb = np.load(os.path.join(path,'ruarobot/amb_test_emb.npy')).squeeze()
    neg_test_emb = np.load(os.path.join(path,'ruarobot/neg_test_emb.npy')).squeeze()

    # kmeans = KMeans(n_clusters=num_tasks)
    # t_labels_train = kmeans.fit_predict(np.concatenate((
    #     pos_emb, amb_emb, neg_emb
    #     )))
    # t_labels_test = kmeans.predict(np.concatenate((
    #     pos_test_emb, amb_test_emb, neg_test_emb
    #     )))


    y_labels_train = np.concatenate((
        np.ones(pos_emb.shape[0], dtype=np.int64),
        np.ones(amb_emb.shape[0], dtype=np.int64), 
        np.zeros(neg_emb.shape[0], dtype=np.int64), 
        ))
    y_labels_test = np.concatenate((
        np.ones(pos_test_emb.shape[0], dtype=np.int64),
        np.ones(amb_test_emb.shape[0], dtype=np.int64), 
        np.zeros(neg_test_emb.shape[0], dtype=np.int64), 
        ))
    x_train = np.concatenate((pos_emb, amb_emb, neg_emb))
    x_test = np.concatenate((pos_test_emb, amb_test_emb, neg_test_emb))
    if args.train_type == 'intercontinet':
        x_train[x_train < 0] = 0
        x_test[x_test < 0] = 0
    dataset_train = InMemoryDataset(x=x_train, y=y_labels_train, data_type=TaskType.TENSOR)
    dataset_test = InMemoryDataset(x=x_test, y=y_labels_test, data_type=TaskType.TENSOR)

    return dataset_train, dataset_test
