import matplotlib.pyplot as plot
import pandas as pd

#plot
df1 = pd.read_csv('results',sep=';')
fracs = np.unique(df.p)
m_mix, s_mix = [], []
m_local, s_local = [], []
m_fed, s_fed = [], []
m_ft, s_ft = [], []
m_e, s_e = [], []
m_mixFed, s_mixFed = [], []
m_e2e, s_e2e = [], []

for p in fracs:
    mean_local = df1[df1.p == p].val_acc_avg_locals.mean()
    mean_fed = df1[df1.p == p].val_acc_avg_fedavg.mean()
    mean_ft = df1[df1.p == p].ft_valacc.mean()
    mean_e2e = df1[df1.p == p].val_acc_avg_e2e.mean()

    std_local = df1[df1.p == p].val_acc_avg_locals.std()
    std_fed = df1[df1.p == p].val_acc_avg_fedavg.std()
    std_ft = df1[df1.p == p].ft_valacc.std()
    std_e2e = df1[df1.p == p].val_acc_avg_e2e.std()


    m_local.append(mean_local)
    m_fed.append(mean_fed)
    m_ft.append(mean_ft)
    m_e2e.append(mean_e2e)

    s_local.append(std_local)
    s_fed.append(std_fed)
    s_ft.append(std_ft)
    s_e2e.append(std_e2e)

plt.plot(fracs,m_e2e,'-o',color='tab:blue')
plt.plot(fracs, m_local,'-o',color='tab:orange')
plt.plot(fracs,m_ft,'-o',color='tab:red')
plt.plot(fracs,m_fed,'-o',color='tab:green')

plt.xlabel("Majority class fraction")
plt.ylabel('Validation accuracy')
plt.legend(['Mixture','Local', 'Finetuned','FedAvg'])
plt.savefig('plot.png')