# Autonomous RL Baselines

## Instructions

Install [MuJoCo](http://www.mujoco.org/) if it is not already the case:

* Obtain a license on the [MuJoCo website](https://www.roboti.us/license.html).
* Download MuJoCo binaries [here](https://www.roboti.us/index.html).
* Unzip the downloaded archive into `~/.mujoco/mujoco200` and place your license key file `mjkey.txt` at `~/.mujoco`.
* Use the env variables `MUJOCO_PY_MJKEY_PATH` and `MUJOCO_PY_MUJOCO_PATH` to specify the MuJoCo license key path and the MuJoCo directory path.
* Append the MuJoCo subdirectory bin path into the env variable `LD_LIBRARY_PATH`.

Install the following libraries:
```sh
sudo apt update
sudo apt install libosmesa6-dev libgl1-mesa-glx libglfw3
```

Install dependencies:
```sh
conda env create -f conda_env.yml
conda activate arl116
```

### Instructions to run in simulation
Download and unzip the demos folder locally. The folder 'vision_demos' should now have all vision demos necessary to run experiments. Now, train an autonomous RL agent using MEDAL:
```sh
python3 medalplusplus.py
```

Monitor results:
```sh
tensorboard --logdir exp_local
```

To fetch the latest version of our robot environment and the corresponding instructions. You will need to follow the instructions for demo collection
tailored towards your scene setup and move the subsequent forward/backward demo files under the ``franka_demos`` folder within the respective task subfolder.