# Quantized Disentangled Representations for Object-Centric Visual Tasks
This repository is the official implementation of the paper "Quantized Disentangled Representations for Object-Centric Visual Tasks".

## Download CLEVR data
To use our model you are supposed to download and unzip [CLEVR](https://cs.stanford.edu/people/jcjohns/clevr/) dataset in the repository folder
```bash
wget https://dl.fbaipublicfiles.com/clevr/CLEVR_v1.0.zip
unzip CLEVR_v1.0.zip
```
## CLEVR propery prediction
We use set prediction task as main as the main measure of the performance of our approach.

## Evaluate pretrained model
To evaluate pretrained model run this command
```bash
python eval.py --model_path <path_to_pretrained_weights>
```
`base_quant.pth` contains default pretrained weights

## Train model from scratch
To train set prediction model, run this command:
```bash
python train.py 
```
## Results
With pretrained weights from `base_quant.pth` our model achives the following performance on the CLEVR set property prediction task:
| Distance threshold  | Average Precision  |
| ------------------ |---------------- |
|  $\infty$  |    0.96       |
|  1  |    0.914       |
|  0.5  |    0.736       |
|  0.25  |    0.233       |
|  0.125  |    0.025       |