clearvars
clc
%close all
addpath 'helper_functions'

hf = figure(1);
hf.Position = [100 100 250 250];
ax = gca;

%% noise test 

err_avg = [];
err_up = [];
err_down = [];

for n=[4, 6]
    
    load(sprintf('results/PM_vs_SPM_noise_%d.mat', n/2));
    %ax = subplot('Position', [0.72, 0.15, 0.25, 0.75]);

    N = size(err_all_n, 3);
    %err_all_s = sort(err_all_n,3);

    %err_log = mean(log(err_all_n),3);
    %err_std_log = std(log(err_all_n),0,3);

    %err_avg = [err_avg, exp(err_log)];
    %err_up = [err_up, exp(err_log + err_std_log)];
    %err_down = [err_down, exp(err_log - err_std_log)];
    
    err_avg_ = mean(err_all_n,3);
    err_avg = [err_avg, err_avg_];
    err_std = std(err_all_n,0,3);
    err_up = [err_up, err_avg_ + err_std];
    err_down = [err_down, err_avg_ - err_std];
    

end

[hpl, hpa] = error_shaded(vecnoise, err_avg, err_up, err_down);

hpl(2).LineStyle = '--';
hpl(3).LineStyle = '-.';
hpl(4).LineStyle = ':';
hpl(2).Color = hpl(3).Color;
hpl(3).Color = hpa(2).FaceColor;
hpl(4).Color = [0 .7 0];
for i=1:4
    hpl(i).LineWidth = 1.5;
    hpa(i).YData = max(hpa(i).YData, 1e-14);
    hpa(i).FaceColor = hpl(i).Color;
end
%h(1) = errorbar(vecL, err_LR(:,1), err_std_LR(:,1));
%hold on;
%h(2) = errorbar(vecL, err_LR(:,2), err_std_LR(:,2));

ax.XScale = 'log';
ax.YScale = 'log';
xlabel('$\sigma$','Interpreter','latex');
ylabel('avg $\min_i\|x_*-a_i\|_2$','Interpreter','latex');
legk = {'\textbf{PM-P} $(n=2)$', '\textbf{PM-P} $(n=3)$', '\textbf{nSPM-P} $(n=2)$', '\textbf{nSPM-P} $(n=3)$'};
hl(3) = legend(ax,hpl([1,3,2,4]), legk, 'Interpreter','latex','Location','southeast','FontSize', 9);
%hl(3).Position = [0.7292    0.5262    0.0797    0.1462];
ylim([1e-8, 1]);


set(ax,'XScale','log','YScale','log', 'FontSize',10,...
        'TickLabelInterpreter','latex')

pdfprint('results/PM_vs_SPM_noise_final', hf)

function [] = print_plot(filename, figure)
% Print a figure in pdf (for nice vectorized pictures)
% Solution in https://www.mathworks.com/matlabcentral/answers/12987-how-to-save-a-matlab-graphic-in-a-right-size-pdf

    if ~exist('figure', 'var') || isempty(figure)
        figure = gcf;
    end
    
    set(figure ,'Units','Inches');
    pos = get(figure ,'Position');
    set(figure ,'PaperPositionMode','Auto',...
                'PaperUnits','Inches',...
                'PaperSize',[pos(3), pos(4)]);
    print(figure, filename,'-dpdf','-r300');




end
