clearvars
clc
close all
addpath 'helper_functions'


% hf = figure(1);
% hpl = semilogy(err);
% hpl(4).Color = [0 .7 0];
% xlim([1, R]);
% 
% hf = figure(2);
% ha = gca;
% hold off
% for i=1:4
%     h = errorbar(err(:,i), err(:,i) .* (err_std(:,i)-1));
%     h.YNegativeDelta = err(:,i) ./ err_std(:,i) - err(:,i);
%     hold on
% end
% hold off
% h.Color = [0 .7 0];
% ha.YScale = 'log';
% xlim([1, R]);

hf = figure(1);
hf.Position = [100 100 550 250];

load('results/deflation_L40R200n4.mat')

ha = subplot('Position', [0.1, 0.2, 0.31, 0.7]);

[hpl, hpa] = error_shaded(1:R, err(:, 4:-1:1), err_std(:, 4:-1:1));
hpl(4).Color = [0 .7 0];
hpa(4).FaceColor = [0 .7 0];
hpl(2).LineStyle = '--';
hpl(3).LineStyle = '-.';
hpl(4).LineStyle = '--';
for hplk=hpl.'
    hplk.LineWidth = 1.5;
end
%for i=1:4
%    hpa(i).YData = max(hpa(i).YData, vecnoise(5-i)/100);
%end
% hold on
% for i=1:4
%     hpa = patch([1:R, R:-1:1]', [err(:,i) + err_std(:,i); ...
%         max(err(R:-1:1,i) - err_std(:,i), 1e-6)] , hpl(5-i).Color);
%     %err(R:-1:1,i) ./ (1 + err_std(:,i) ./ err(:,i))], hpl(i).Color);
%     %hpa = patch([1:R, R:-1:1]', [err(:,i) .* err_std(:,i);...
%     %            err(R:-1:1,i) ./ err_std(R:-1:1,i)], hpl(i).Color);
%     hpa.EdgeColor = 'none';
%     hpa.FaceAlpha = 0.3;
% end
% hold off
ha.YScale = 'log';
xlabel('$k$','Interpreter','latex');
ylabel('$\min_{i,s}\|x_k - s a_i\|_2$','Interpreter','latex');
xlim([1, R]);
ylim([5e-8, 5e-4])
legk = cell(1,4);
for k = 1:4
    legk{5-k} = sprintf('$\\sigma = 10^{%d}$',log10(vecnoise(k)));
 %                strrep(    'e', '\times 10^{');
end
hl = legend(hpl, legk,'Interpreter','latex','Location','best','FontSize',10);
hl.Position = [0.8350    0.4008    0.1321    0.2734];
title('$(n=2)$','Interpreter','latex')
set(ha,'YScale','log', 'FontSize',10,...
        'TickLabelInterpreter','latex')

load('results/deflation_L15R200n6.mat')

ha = subplot('Position', [0.48, 0.2, 0.31, 0.7]);

[hpl, hpa] = error_shaded(1:R, err(:, 4:-1:1), err_std(:, 4:-1:1));
hpl(4).Color = [0 .7 0];
hpa(4).FaceColor = [0 .7 0];
hpl(2).LineStyle = '--';
hpl(3).LineStyle = '-.';
hpl(4).LineStyle = '--';
for hplk=hpl.'
    hplk.LineWidth = 1.5;
end
%for i=1:4
%    hpa(i).YData = max(hpa(i).YData, vecnoise(5-i)/100);
%end
% hold on
% for i=1:4
%     hpa = patch([1:R, R:-1:1]', [err(:,i) + err_std(:,i); ...
%         max(err(R:-1:1,i) - err_std(:,i), 1e-6)] , hpl(5-i).Color);
%     %err(R:-1:1,i) ./ (1 + err_std(:,i) ./ err(:,i))], hpl(i).Color);
%     %hpa = patch([1:R, R:-1:1]', [err(:,i) .* err_std(:,i);...
%     %            err(R:-1:1,i) ./ err_std(R:-1:1,i)], hpl(i).Color);
%     hpa.EdgeColor = 'none';
%     hpa.FaceAlpha = 0.3;
% end
% hold off
ha.YScale = 'log';
xlabel('$k$','Interpreter','latex');
xlim([1, R]);
ylim([5e-8, 5e-4])
title('$(n=3)$','Interpreter','latex')
set(ha,'YScale','log', 'FontSize',10,...
        'TickLabelInterpreter','latex')
    
pdfprint('results/deflation_final', hf)